/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationListener;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationResult;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.Messages;
import org.eclipse.statet.internal.r.debug.ui.RDebugUIPlugin;
import org.eclipse.statet.internal.r.debug.ui.actions.AbstractDebugHandler;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.debug.core.IRElementVariable;
import org.eclipse.statet.r.debug.core.IREvaluationResult;
import org.eclipse.statet.r.debug.core.IRStackFrame;
import org.eclipse.statet.r.debug.core.IRVariable;
import org.eclipse.statet.r.debug.core.RDebugModel;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public class InspectHandler
extends AbstractDebugHandler {
    private boolean isExpressionElementVariable(TreePath treePath) {
        Object firstSegment = treePath.getFirstSegment();
        if (!(firstSegment instanceof IExpression) || ((IExpression)firstSegment).getExpressionText().isEmpty()) {
            return false;
        }
        int i = 1;
        while (i < treePath.getSegmentCount()) {
            Object segment = treePath.getSegment(i);
            if (!(segment instanceof IRVariable)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private @Nullable String getExpressionElementVariableExpression(TreePath treePath) {
        String expressionText;
        Object firstSegment = treePath.getFirstSegment();
        if (!(firstSegment instanceof IExpression) || (expressionText = ((IExpression)firstSegment).getExpressionText()).isEmpty()) {
            return null;
        }
        ArrayList<RElementName> segments = new ArrayList<RElementName>();
        segments.add(RElementName.create((int)17, (String)"expr"));
        int i = 1;
        while (i < treePath.getSegmentCount()) {
            Object segment = treePath.getSegment(i);
            if (!(segment instanceof IRVariable)) {
                return null;
            }
            if (segment instanceof IRElementVariable) {
                CombinedRElement element = ((IRElementVariable)segment).getElement();
                segments.add(element.getElementName());
            }
            ++i;
        }
        if (segments.size() == 1) {
            return null;
        }
        String subName = RElementName.create(segments).getDisplayName(2);
        if (subName == null) {
            return null;
        }
        return String.valueOf(expressionText) + subName.substring(4);
    }

    public void setEnabled(Object evaluationContext) {
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)evaluationContext);
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)evaluationContext);
        if (part != null && selection != null && this.getContextElement(null, part) != null) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                if (structSelection.size() != 1) {
                    this.setBaseEnabled(false);
                    return;
                }
                Object obj = structSelection.getFirstElement();
                if (obj instanceof IExpression) {
                    this.setBaseEnabled(!((IExpression)obj).getExpressionText().isEmpty());
                    return;
                }
                if (obj instanceof IRElementVariable) {
                    if (((IRElementVariable)obj).getFQElementName() != null) {
                        this.setBaseEnabled(true);
                    } else if (selection instanceof ITreeSelection && this.isExpressionElementVariable(((ITreeSelection)selection).getPaths()[0])) {
                        this.setBaseEnabled(true);
                    } else {
                        this.setBaseEnabled(false);
                    }
                    return;
                }
                this.setBaseEnabled(false);
                return;
            }
            if (selection instanceof ITextSelection && part instanceof IRSourceEditor) {
                this.setBaseEnabled(true);
                return;
            }
        }
        this.setBaseEnabled(false);
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        if (part != null && selection != null) {
            ISourceEditor sourceEditor;
            ITextSelection textSelection;
            String expression;
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                Object obj = structSelection.getFirstElement();
                String expression2 = null;
                if (obj instanceof IExpression) {
                    expression2 = ((IExpression)obj).getExpressionText();
                }
                if (obj instanceof IRElementVariable && (expression2 = this.getExpressionText((IRElementVariable)obj)) == null && selection instanceof ITreeSelection) {
                    expression2 = this.getExpressionElementVariableExpression(((ITreeSelection)selection).getPaths()[0]);
                }
                if (expression2 != null) {
                    IRStackFrame stackFrame = this.getContextStackFrame(part);
                    if (stackFrame == null) {
                        LTKWorkbenchUIUtil.indicateStatus((IStatus)new StatusInfo(4, Messages.Expression_Context_Missing_message), (ExecutionEvent)event);
                        return null;
                    }
                    String commandExpression = this.toCommandExpression(expression2);
                    ResultHandler resultHandler = commandExpression != expression2 ? new VariablePopupResultHandler(part, structSelection) : new ResultHandler(part);
                    stackFrame.getThread().evaluate(commandExpression, stackFrame, false, (IEvaluationListener)resultHandler);
                }
            } else if (selection instanceof ITextSelection && part instanceof IRSourceEditor && (expression = this.getExpressionText(textSelection = (ITextSelection)selection, sourceEditor = (ISourceEditor)part)) != null && sourceEditor.getWorkbenchPart() != null) {
                IRStackFrame stackFrame = this.getContextStackFrame(part);
                if (stackFrame == null) {
                    LTKWorkbenchUIUtil.indicateStatus((IStatus)new StatusInfo(4, Messages.Expression_Context_Missing_message), (ExecutionEvent)event);
                    return null;
                }
                String commandExpression = this.toCommandExpression(expression);
                SourceEditorPopupResultHandler resultHandler = new SourceEditorPopupResultHandler(sourceEditor);
                stackFrame.getThread().evaluate(commandExpression, stackFrame, false, (IEvaluationListener)resultHandler);
            }
        }
        return null;
    }

    protected String getCommandId() {
        return "org.eclipse.jdt.debug.ui.commands.Inspect";
    }

    protected String toCommandExpression(String expression) {
        return expression;
    }

    private static class RInspectPopupDialog
    extends InspectPopupDialog {
        private final Viewer viewer;
        private final ISelection savedSelection;

        public RInspectPopupDialog(Shell shell, Point anchor, String commandId, IExpression expression, Viewer viewer, ISelection savedSelection) {
            super(shell, anchor, commandId, expression);
            this.viewer = viewer;
            this.savedSelection = savedSelection;
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            return control;
        }

        public boolean close() {
            boolean closed = super.close();
            if (UIAccess.isOkToUse((Viewer)this.viewer) && this.savedSelection != null && !this.savedSelection.equals(this.viewer.getSelection())) {
                this.viewer.setSelection(this.savedSelection);
            }
            return closed;
        }
    }

    private class ResultHandler
    implements IEvaluationListener,
    Runnable {
        protected final IWorkbenchPart workbenchPart;
        protected final Display display;
        protected @Nullable IErrorReportingExpression expression;

        public ResultHandler(IWorkbenchPart part) {
            this.workbenchPart = part;
            this.display = part.getSite().getShell().getDisplay();
        }

        protected void dispose() {
            if (this.expression != null) {
                this.expression.dispose();
                this.expression = null;
            }
        }

        public void evaluationFinished(@NonNull IEvaluationResult result) {
            if (!(result.getValue() == null && result.getMessages() == null || RDebugUIPlugin.getInstance() == null || this.display.isDisposed())) {
                this.expression = RDebugModel.createExpression((IREvaluationResult)((IREvaluationResult)result));
                this.display.asyncExec((Runnable)this);
            } else {
                result.free();
                this.dispose();
            }
        }

        protected @Nullable Shell getShell() {
            return this.workbenchPart.getSite().getShell();
        }

        @Override
        public void run() {
            DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)this.expression);
            InspectHandler.showView(this.workbenchPart, "org.eclipse.debug.ui.ExpressionView");
        }
    }

    private class SourceEditorPopupResultHandler
    extends ResultHandler {
        private final ISourceEditor editor;
        private final IDocument document;
        private final @Nullable Position position;

        public SourceEditorPopupResultHandler(ISourceEditor editor) {
            super(editor.getWorkbenchPart());
            this.editor = editor;
            this.document = editor.getViewer().getDocument();
            this.position = InspectHandler.this.markExpressionPosition(this.document);
        }

        @Override
        protected void dispose() {
            super.dispose();
            InspectHandler.disposePosition(this.document, this.position);
        }

        @Override
        public void run() {
            try {
                Shell shell = this.getShell();
                SourceViewer viewer = this.editor.getViewer();
                if (UIAccess.isOkToUse((Control)shell) && this.workbenchPart.getSite().getPage().isPartVisible(this.workbenchPart) && UIAccess.isOkToUse((Viewer)viewer) && viewer.getDocument() == this.document) {
                    ISelection savedSelection = viewer.getSelection();
                    Point anchor = InspectHandler.preparePopup((TextViewer)viewer, this.position);
                    RInspectPopupDialog popup = new RInspectPopupDialog(this.getShell(), anchor, InspectHandler.this.getCommandId(), (IExpression)this.expression, (Viewer)viewer, savedSelection);
                    popup.open();
                    this.expression = null;
                }
            }
            finally {
                this.dispose();
            }
        }
    }

    private class VariablePopupResultHandler
    extends ResultHandler {
        private final IStructuredSelection selection;

        public VariablePopupResultHandler(IWorkbenchPart part, IStructuredSelection selection) {
            super(part);
            this.selection = selection;
        }

        @Override
        public void run() {
            try {
                Shell shell = this.getShell();
                if (UIAccess.isOkToUse((Control)shell) && this.workbenchPart.getSite().getPage().isPartVisible(this.workbenchPart)) {
                    StructuredViewer viewer = InspectHandler.getStructuredViewer(this.workbenchPart);
                    ISelection savedSelection = viewer != null ? viewer.getSelection() : null;
                    Point anchor = viewer != null ? InspectHandler.preparePopup(viewer, this.selection) : InspectHandler.preparePopup(this.workbenchPart);
                    RInspectPopupDialog popup = new RInspectPopupDialog(shell, anchor, InspectHandler.this.getCommandId(), (IExpression)this.expression, (Viewer)viewer, savedSelection);
                    popup.open();
                    this.expression = null;
                }
            }
            finally {
                this.dispose();
            }
        }
    }
}

