/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.components.DataAdapter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

@NonNullByDefault
public class ButtonGroup<TItem>
extends Composite {
    public static final int ADD_NEW = 1;
    public static final int ADD_COPY = 2;
    public static final int ADD_ANY = 3;
    public static final int EDIT = 4;
    private static final Object FIRST_ELEMENT = new Object();
    private DataAdapter<TItem> dataAdapter;
    private IActions<TItem> actions;
    private StructuredViewer viewer;
    private boolean treeMode;
    private boolean cellMode;
    private @Nullable SelectionHandler<?> editHandler;
    private @Nullable SelectionHandler<?> deleteHandler;
    private final List<SelectionHandler<?>> handlers = new ArrayList();
    private int cachedWidthHint;

    public ButtonGroup(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)LayoutUtils.newCompositeGrid());
    }

    public ButtonGroup(Composite parent, IActions<TItem> actions, boolean cellMode) {
        super(parent, 0);
        this.setLayout((Layout)LayoutUtils.newCompositeGrid());
        this.actions = actions;
        this.cellMode = cellMode;
    }

    public DataAdapter<TItem> getDataAdapter() {
        return this.dataAdapter;
    }

    protected void addLayoutData(Control control) {
        if (this.cachedWidthHint == 0 && control instanceof Button) {
            this.cachedWidthHint = LayoutUtils.hintWidth((Button)control);
        }
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = this.cachedWidthHint;
        control.setLayoutData((Object)gd);
    }

    public void add(Control control, SelectionHandler<TItem> handler) {
        handler.group = this;
        handler.control = control;
        this.addLayoutData(control);
        control.addDisposeListener(handler);
        if (control instanceof Button) {
            ((Button)control).addSelectionListener(handler);
        }
        this.handlers.add(handler);
    }

    public void addAddButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        String label = SharedMessages.CollectionEditing_AddItem_label;
        if (!this.cellMode) {
            label = String.valueOf(label) + "...";
        }
        button.setText(label);
        if (handler == null) {
            handler = new AddHandler();
        }
        this.add((Control)button, handler);
    }

    public void addCopyButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        String label = SharedMessages.CollectionEditing_CopyItem_label;
        if (!this.cellMode) {
            label = String.valueOf(label) + "...";
        }
        button.setText(label);
        if (handler == null) {
            handler = new CopyHandler();
        }
        this.add((Control)button, handler);
    }

    public void addEditButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        String label = SharedMessages.CollectionEditing_EditItem_label;
        if (!this.cellMode) {
            label = String.valueOf(label) + "...";
        }
        button.setText(label);
        if (handler == null) {
            handler = new EditHandler();
        }
        this.editHandler = handler;
        this.add((Control)button, handler);
    }

    public void addDeleteButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        button.setText(SharedMessages.CollectionEditing_RemoveItem_label);
        if (handler == null) {
            handler = new DeleteHandler();
        }
        this.deleteHandler = handler;
        this.add((Control)button, handler);
    }

    public void addDefaultButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        button.setText(SharedMessages.CollectionEditing_DefaultItem_label);
        if (handler == null) {
            handler = new DefaultHandler();
        }
        this.add((Control)button, handler);
    }

    public void addUpButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        button.setText(SharedMessages.CollectionEditing_MoveItemUp_label);
        if (handler == null) {
            handler = new MoveHandler(-1);
        }
        this.add((Control)button, handler);
    }

    public void addDownButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        button.setText(SharedMessages.CollectionEditing_MoveItemDown_label);
        if (handler == null) {
            handler = new MoveHandler(1);
        }
        this.add((Control)button, handler);
    }

    public void addImportButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        button.setText(SharedMessages.CollectionEditing_Import_label);
        if (handler == null) {
            handler = new ImportHandler();
        }
        this.add((Control)button, handler);
    }

    public void addExportButton(@Nullable SelectionHandler<TItem> handler) {
        Button button = new Button((Composite)this, 8);
        button.setText(SharedMessages.CollectionEditing_Export_label);
        if (handler == null) {
            handler = new ExportHandler();
        }
        this.add((Control)button, handler);
    }

    public void addSeparator() {
        LayoutUtils.addSmallFiller(this, false);
    }

    public void connectTo(StructuredViewer viewer, @Nullable IObservableCollection<TItem> list, IObservableValue<@Nullable TItem> defaultValue) {
        if (list != null) {
            this.connectTo(viewer, new DataAdapter.ListAdapter<TItem>(list, defaultValue));
        } else if (viewer.getContentProvider() instanceof ITreeContentProvider) {
            this.connectTo(viewer, new DataAdapter.TreeAdapter((ITreeContentProvider)viewer.getContentProvider(), defaultValue));
        } else {
            this.connectTo(viewer, new DataAdapter(defaultValue));
        }
    }

    public void connectTo(StructuredViewer viewer, DataAdapter<TItem> adapter) {
        this.viewer = viewer;
        this.treeMode = viewer instanceof AbstractTreeViewer;
        if (this.deleteHandler != null) {
            this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    SelectionHandler<?> handler = ButtonGroup.this.deleteHandler;
                    if (event.character == '\u007f' && event.stateMask == 0 && handler != null) {
                        handler.run((IStructuredSelection)ButtonGroup.this.viewer.getSelection());
                    }
                }
            });
        }
        if (this.editHandler != null && !this.cellMode) {
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    SelectionHandler<?> handler = ButtonGroup.this.editHandler;
                    if (handler != null && !handler.run(selection) && ButtonGroup.this.treeMode && selection.size() == 1) {
                        ((AbstractTreeViewer)ButtonGroup.this.viewer).setExpandedState(selection.getFirstElement(), !((AbstractTreeViewer)ButtonGroup.this.viewer).getExpandedState(selection.getFirstElement()));
                    }
                }
            });
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ButtonGroup.this.updateState();
            }
        });
        this.dataAdapter = adapter;
    }

    public void setCheckedModel(Set<TItem> set) {
        this.dataAdapter.setCheckedModel(set);
    }

    public void updateState() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (SelectionHandler<?> handler : this.handlers) {
            handler.update(selection);
        }
        if (this.actions != null) {
            this.actions.updateState(selection);
        }
    }

    public void editElement(int command, @Nullable Object element) {
        Object editItem;
        Object parent;
        Object orgItem = (command & 1) == 0 && element != null ? (Object)this.dataAdapter.getModelItem(element) : null;
        Object object = parent = (command & 1) != 0 ? this.dataAdapter.getAddParent(element) : this.dataAdapter.getParent(element);
        Object object2 = this.actions != null ? this.actions.edit(command, (command & 1) == 0 ? orgItem : null, parent) : (editItem = this.edit1((command & 1) == 0 ? orgItem : null, (command & 3) != 0, parent));
        if (editItem == null) {
            return;
        }
        element = this.dataAdapter.change((command & 3) == 0 ? orgItem : null, editItem, parent, this.dataAdapter.getContainerFor(element));
        this.refresh0(element, null);
        if (this.viewer instanceof ColumnViewer) {
            ((ColumnViewer)this.viewer).editElement(element, 0);
        }
    }

    public void apply(TItem oldItem, TItem newItem) {
        if (newItem == null) {
            this.delete0(Collections.singletonList(oldItem));
        } else {
            Object element = this.dataAdapter.change(oldItem, newItem, null, this.dataAdapter.getContainerFor(this.dataAdapter.getViewerElement(oldItem != null ? oldItem : newItem, null)));
            this.refresh0(element, null);
        }
    }

    public void deleteElements(int command, List<? extends @NonNull Object> elements) {
        this.delete0(elements);
    }

    public void setDefault(Object element) {
        this.setDefault0(element);
    }

    @Deprecated
    protected @Nullable TItem edit1(@Nullable TItem item, boolean newItem, Object parent) {
        return null;
    }

    private void delete0(List<? extends @NonNull Object> elements) {
        if (elements.isEmpty()) {
            return;
        }
        Object elementToSelect = this.getBestNeighbour(elements);
        this.dataAdapter.delete(elements);
        this.refresh0(null, elementToSelect);
    }

    private @Nullable Object getBestNeighbour(List<? extends @NonNull Object> elements) {
        ImList neighbours;
        int idx;
        Object container;
        Object parent = this.dataAdapter.getParent(elements.get(elements.size() - 1));
        Object[] array = null;
        if (parent != null) {
            array = this.dataAdapter.getChildren(parent);
        }
        if (array == null && (container = this.dataAdapter.getContainerFor(elements.get(elements.size() - 1))) instanceof Collection) {
            array = ((Collection)container).toArray();
        }
        if (array == null) {
            return null;
        }
        ViewerComparator comparator = this.viewer.getComparator();
        if (comparator != null) {
            comparator.sort((Viewer)this.viewer, array);
        }
        if ((idx = (neighbours = ImCollections.newList((Object[])array)).indexOf(elements.get(elements.size() - 1))) >= 0) {
            int i = idx + 1;
            while (i < neighbours.size()) {
                if (!elements.contains(neighbours.get(i))) break;
                ++i;
            }
            if (i == neighbours.size()) {
                i = idx - 1;
                while (i >= 0) {
                    if (!elements.contains(neighbours.get(i))) break;
                    --i;
                }
            }
            idx = i;
        }
        if (idx >= 0) {
            return neighbours.get(idx);
        }
        return parent;
    }

    private void setDefault0(Object element) {
        TItem item = this.dataAdapter.getModelItem(element);
        this.dataAdapter.setDefault(item);
        this.refresh0(null, null);
    }

    private void move0(Object element, int direction) {
        this.dataAdapter.move(element, direction);
        this.refresh0(element, null);
    }

    private void import0() {
        ((IImportExportActions)this.actions).importItems();
        this.refresh0(null, null);
    }

    private void export0(List<? extends @NonNull Object> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        ((IImportExportActions)this.actions).exportItems(items);
    }

    public void refresh() {
        this.refresh0(null, FIRST_ELEMENT);
    }

    public void refresh(TItem elementToSelect) {
        this.refresh0(elementToSelect, null);
    }

    private void refresh0(@Nullable Object elementToSelect, @Nullable Object elementToSelect2) {
        this.refresh1();
        if ((elementToSelect != null || elementToSelect2 != null) && UIAccess.isOkToUse((Viewer)this.viewer)) {
            if (elementToSelect != null) {
                this.select(elementToSelect);
            }
            if (elementToSelect2 != null && this.viewer.getSelection().isEmpty()) {
                if (elementToSelect2 == FIRST_ELEMENT) {
                    elementToSelect2 = this.viewer instanceof AbstractTableViewer ? ((AbstractTableViewer)this.viewer).getElementAt(0) : null;
                }
                if (elementToSelect2 != null) {
                    this.select(elementToSelect2);
                }
            }
        }
        this.updateState();
    }

    private void select(Object element) {
        if (this.treeMode) {
            ViewerUtils.expandToLevel((AbstractTreeViewer)this.viewer, element, 0);
        }
        this.viewer.setSelection((ISelection)new StructuredSelection(element), true);
    }

    protected void refresh1() {
        this.viewer.refresh();
    }

    public static class AddHandler<TItem>
    extends SelectionHandler<TItem> {
        @Override
        public void update(IStructuredSelection selection) {
            if (this.getGroup().treeMode) {
                Object element = this.getElement(selection);
                this.setEnabled(element != null && this.getGroup().getDataAdapter().isAddAllowed(element));
            } else {
                this.setEnabled(true);
            }
        }

        @Override
        public boolean run(IStructuredSelection selection) {
            this.getGroup().editElement(1, this.getElement(selection));
            return true;
        }
    }

    public static class CopyHandler<TItem>
    extends SelectionHandler<TItem> {
        @Override
        protected @Nullable Object getElement(IStructuredSelection selection) {
            Object element = super.getElement(selection);
            return element != null && this.getGroup().getDataAdapter().isModifyAllowed(element) ? element : null;
        }

        @Override
        public boolean run(IStructuredSelection selection) {
            Object element = this.getElement(selection);
            if (element != null) {
                this.getGroup().editElement(2, element);
                return true;
            }
            return false;
        }
    }

    public static class DefaultHandler<TItem>
    extends SelectionHandler<TItem> {
        @Override
        protected @Nullable Object getElement(IStructuredSelection selection) {
            Object element = super.getElement(selection);
            return element != null && this.getGroup().getDataAdapter().isContentItem(element) ? element : null;
        }

        @Override
        public boolean run(IStructuredSelection selection) {
            Object element = this.getElement(selection);
            if (element != null) {
                this.getGroup().setDefault(element);
                return true;
            }
            return false;
        }
    }

    public static class DeleteHandler<TItem>
    extends ElementListHandler<TItem> {
        @Override
        protected @Nullable List<? extends @NonNull Object> getElement(IStructuredSelection selection) {
            Object list = super.getElement(selection);
            if (list != null) {
                DataAdapter adapter = this.getGroup().getDataAdapter();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (adapter.isDeleteAllowed(object)) continue;
                    return null;
                }
            }
            return list;
        }

        @Override
        public boolean run(IStructuredSelection selection) {
            Object list = this.getElement(selection);
            if (list != null) {
                this.getGroup().delete0((List<Object>)list);
                return true;
            }
            return false;
        }
    }

    public static class EditHandler<TItem>
    extends SelectionHandler<TItem> {
        @Override
        protected @Nullable Object getElement(IStructuredSelection selection) {
            Object element = super.getElement(selection);
            return element != null && this.getGroup().getDataAdapter().isModifyAllowed(element) ? element : null;
        }

        @Override
        public boolean run(IStructuredSelection selection) {
            Object element = this.getElement(selection);
            if (element != null) {
                this.getGroup().editElement(4, element);
                return true;
            }
            return false;
        }
    }

    public static class ElementListHandler<TItem>
    extends SelectionHandler<TItem> {
        @Override
        public void update(IStructuredSelection selection) {
            Object list = this.getElement(selection);
            this.setEnabled(list != null && !list.isEmpty());
        }

        @Override
        protected @Nullable List<? extends @NonNull Object> getElement(IStructuredSelection selection) {
            return selection.toList();
        }

        @Override
        public boolean run(IStructuredSelection selection) {
            return false;
        }
    }

    public static class ExportHandler<TItem>
    extends ItemListHandler<TItem> {
        @Override
        public boolean run(IStructuredSelection selection) {
            Object list = this.getElement(selection);
            if (list != null) {
                this.getGroup().export0((List<Object>)list);
                return true;
            }
            return false;
        }
    }

    public static interface IActions<ItemType> {
        public @Nullable ItemType edit(int var1, @Nullable ItemType var2, @Nullable Object var3);

        public void updateState(IStructuredSelection var1);
    }

    public static interface IImportExportActions<ItemType>
    extends IActions<ItemType> {
        public void importItems();

        public void exportItems(List<? extends @NonNull Object> var1);
    }

    public static class ImportHandler<TItem>
    extends SelectionHandler<TItem> {
        @Override
        public void update(IStructuredSelection selection) {
        }

        @Override
        public boolean run(IStructuredSelection selection) {
            this.getGroup().import0();
            return true;
        }
    }

    public static class ItemListHandler<TItem>
    extends ElementListHandler<TItem> {
        @Override
        public void update(IStructuredSelection selection) {
            this.setEnabled(this.hasItem(selection.toList()));
        }

        @Override
        protected @Nullable List<@NonNull TItem> getElement(IStructuredSelection selection) {
            return this.getItems(selection.toList());
        }

        protected boolean hasItem(List<? extends @NonNull Object> list) {
            DataAdapter dataAdapter = this.getGroup().getDataAdapter();
            for (Object object : list) {
                if (dataAdapter.isContentItem(object)) {
                    return true;
                }
                if (!this.getGroup().treeMode || !this.hasItem(dataAdapter.getChildren(object))) continue;
                return true;
            }
            return false;
        }

        protected boolean hasItem(@NonNull Object @Nullable [] array) {
            if (array != null) {
                DataAdapter dataAdapter = this.getGroup().getDataAdapter();
                Object[] objectArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (dataAdapter.isContentItem(element)) {
                        return true;
                    }
                    if (this.hasItem(dataAdapter.getChildren(element))) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        protected @Nullable List<@NonNull TItem> getItems(List<? extends @NonNull Object> list) {
            if (!list.isEmpty()) {
                DataAdapter dataAdapter = this.getGroup().getDataAdapter();
                ArrayList items = new ArrayList();
                for (Object object : list) {
                    if (dataAdapter.isContentItem(object)) {
                        items.add(dataAdapter.getModelItem(object));
                        continue;
                    }
                    if (!this.getGroup().treeMode) continue;
                    this.collectItems(dataAdapter.getChildren(object), items);
                }
                return items;
            }
            return null;
        }

        protected void collectItems(@NonNull Object @Nullable [] elements, List<TItem> items) {
            if (elements != null) {
                DataAdapter dataAdapter = this.getGroup().getDataAdapter();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (dataAdapter.isContentItem(element)) {
                        items.add(dataAdapter.getModelItem(element));
                    } else {
                        this.collectItems(dataAdapter.getChildren(element), items);
                    }
                    ++n2;
                }
            }
        }
    }

    public static class MoveHandler<TItem>
    extends SelectionHandler<TItem> {
        private final int direction;

        public MoveHandler(int direction) {
            this.direction = direction;
        }

        protected int getDirection() {
            return this.direction;
        }

        @Override
        protected @Nullable Object getElement(IStructuredSelection selection) {
            Object element = super.getElement(selection);
            return element != null && this.getGroup().getDataAdapter().isMoveAllowed(element, this.direction) ? element : null;
        }

        @Override
        public boolean run(IStructuredSelection selection) {
            Object element = this.getElement(selection);
            if (element != null) {
                this.getGroup().move0(element, this.direction);
                return true;
            }
            return false;
        }
    }

    public static class SelectionHandler<TItem>
    extends SelectionAdapter
    implements DisposeListener {
        private ButtonGroup<TItem> group;
        private Control control;

        public void update(IStructuredSelection selection) {
            this.setEnabled(this.getElement(selection) != null);
        }

        protected ButtonGroup<TItem> getGroup() {
            return this.group;
        }

        protected Control getControl() {
            return this.control;
        }

        protected void setEnabled(boolean enabled) {
            this.control.setEnabled(enabled);
        }

        protected @Nullable Object getElement(IStructuredSelection selection) {
            if (selection.size() == 1) {
                return selection.getFirstElement();
            }
            return null;
        }

        public void widgetSelected(SelectionEvent e) {
            this.run((IStructuredSelection)this.group.viewer.getSelection());
        }

        public boolean run(IStructuredSelection selection) {
            return false;
        }

        public void widgetDisposed(DisposeEvent e) {
        }
    }
}

