/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.content;

import org.eclipse.statet.ecommons.ui.content.IElementFilter;
import org.eclipse.statet.ecommons.ui.content.ITextElementFilter;
import org.eclipse.ui.dialogs.SearchPattern;

public class TextElementFilter
implements ITextElementFilter {
    private volatile String text = "";
    private String currentText;
    private Filter currentFilter;

    @Override
    public boolean setText(String text) {
        if (text == null) {
            text = "";
        }
        boolean changed = !this.text.equals(text);
        this.text = text;
        return changed;
    }

    @Override
    public IElementFilter.IFinalFilter getFinal(boolean newData) {
        String text = this.text;
        if (text.length() == 0) {
            this.currentFilter = null;
        } else if (this.currentFilter == null || newData && this.text != this.currentText || !text.equals(this.currentText)) {
            this.currentText = text;
            SearchPattern pattern = this.createSearchPattern();
            pattern.setPattern(text);
            this.currentFilter = new Filter(pattern);
        }
        return this.currentFilter;
    }

    protected SearchPattern createSearchPattern() {
        return new SearchPattern(163);
    }

    protected boolean select(SearchPattern pattern, Object element) {
        return pattern.matches(element.toString());
    }

    private class Filter
    implements IElementFilter.IFinalFilter {
        private final SearchPattern pattern;

        Filter(SearchPattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean select(Object element) {
            return TextElementFilter.this.select(this.pattern, element);
        }

        @Override
        public boolean isSubOf(IElementFilter.IFinalFilter other) {
            return other == null || other instanceof Filter && ((Filter)other).pattern.isSubPattern(this.pattern);
        }

        @Override
        public boolean isEqualTo(IElementFilter.IFinalFilter other) {
            return this == other || other instanceof Filter && this.pattern.equalsPattern(((Filter)other).pattern);
        }
    }
}

