/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.nio.file.Path;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;

public class BrowserDropAdapter
implements DropTargetListener {
    private final Browser browser;

    protected BrowserDropAdapter(Browser view) {
        this.browser = view;
    }

    private void validate(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && (event.operations & 4) == 4) {
            event.detail = 4;
            event.feedback = 1;
            return;
        }
        event.detail = 0;
    }

    public void dragEnter(DropTargetEvent event) {
        this.validate(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.validate(event);
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        String url0;
        String[] urls = (String[])event.data;
        String string = url0 = urls != null && urls.length > 0 ? urls[0] : null;
        if (url0 == null) {
            return;
        }
        try {
            Path path = Path.of(url0, new String[0]);
            if (path.isAbsolute()) {
                this.browser.setUrl(path.toUri().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

