/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class InputHistory<E>
extends WritableList<E> {
    private final int maxLength;

    public InputHistory(int maxLength) {
        this.maxLength = maxLength;
    }

    public void append(E element) {
        this.checkRealm();
        int idx = this.wrappedList.indexOf(element);
        switch (idx) {
            case 0: {
                return;
            }
            case -1: {
                this.addToTop(element);
                return;
            }
        }
        this.moveToTop(idx);
    }

    private void moveToTop(int idx) {
        if (idx == 0) {
            return;
        }
        ListDiffEntry[] diffs = new ListDiffEntry[2];
        Object element = this.wrappedList.remove(idx);
        diffs[0] = Diffs.createListDiffEntry((int)idx, (boolean)false, element);
        this.wrappedList.add(0, element);
        diffs[1] = Diffs.createListDiffEntry((int)0, (boolean)true, element);
        this.fireListChange(Diffs.createListDiff((ListDiffEntry[])diffs));
    }

    private void addToTop(E element) {
        int size = this.wrappedList.size();
        ListDiffEntry[] diffs = new ListDiffEntry[Math.max(size - this.maxLength + 2, 1)];
        int iDiff = 0;
        while (size >= this.maxLength) {
            Object removed = this.wrappedList.remove(--size);
            diffs[iDiff++] = Diffs.createListDiffEntry((int)size, (boolean)false, removed);
        }
        this.wrappedList.add(0, element);
        diffs[iDiff++] = Diffs.createListDiffEntry((int)0, (boolean)true, element);
        this.fireListChange(Diffs.createListDiff((ListDiffEntry[])diffs));
    }
}

