/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers.breadcrumb;

import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.statet.ecommons.ui.workbench.css.StylingUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
class BreadcrumbItemDetails {
    private final Composite detailComposite;
    private final BreadcrumbItem parent;
    private final Composite imageComposite;
    private final Label elementImage;
    private final Composite textComposite;
    private final Label elementText;
    private boolean textVisible;
    private boolean selected;
    private boolean hasFocus;

    public BreadcrumbItemDetails(BreadcrumbItem parent, Composite parentContainer) {
        this.parent = parent;
        this.textVisible = true;
        Composite detailComposite = new Composite(parentContainer, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        detailComposite.setLayout((Layout)layout);
        detailComposite.setData("org.eclipse.e4.ui.css.id", (Object)"BreadcrumbItemDetailComposite");
        this.addElementListener((Control)detailComposite);
        detailComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.detailComposite = detailComposite;
        AccessibleAdapter accessibleListener = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BreadcrumbItemDetails.this.elementText.getText();
            }
        };
        Composite composite = new Composite(this.detailComposite, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginHeight = 1;
        layout2.marginWidth = 2;
        composite.setLayout((Layout)layout2);
        composite.setData("org.eclipse.e4.ui.css.id", (Object)"BreadcrumbItemDetailImageComposite");
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (BreadcrumbItemDetails.this.hasFocus && !BreadcrumbItemDetails.this.isTextVisible()) {
                    e.gc.drawFocus(e.x, e.y, e.width, e.height);
                }
            }
        });
        this.installFocusComposite(composite);
        this.addElementListener((Control)composite);
        composite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.imageComposite = composite;
        Label label = new Label(composite, 0);
        label.setData("org.eclipse.e4.ui.css.id", (Object)"BreadcrumbItemDetailImageLabel");
        label.getAccessible().addAccessibleListener((AccessibleListener)accessibleListener);
        this.addElementListener((Control)label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.elementImage = label;
        composite = new Composite(this.detailComposite, 0);
        layout2 = new GridLayout(1, false);
        layout2.marginHeight = 2;
        layout2.marginWidth = 2;
        composite.setLayout((Layout)layout2);
        composite.setData("org.eclipse.e4.ui.css.id", (Object)"BreadcrumbItemDetailTextComposite");
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (BreadcrumbItemDetails.this.hasFocus && BreadcrumbItemDetails.this.isTextVisible()) {
                    e.gc.drawFocus(e.x, e.y, e.width, e.height);
                }
            }
        });
        this.installFocusComposite(composite);
        this.addElementListener((Control)composite);
        composite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textComposite = composite;
        label = new Label(composite, 0);
        label.setData("org.eclipse.e4.ui.css.id", (Object)"BreadcrumbItemDetailTextLabel");
        label.getAccessible().addAccessibleListener((AccessibleListener)accessibleListener);
        this.addElementListener((Control)label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.elementText = label;
        this.detailComposite.setTabList(new Control[]{this.textComposite});
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public void setToolTip(String text) {
        if (this.isTextVisible()) {
            this.elementText.getParent().setToolTipText(text);
            this.elementText.setToolTipText(text);
            this.elementImage.setToolTipText(text);
        } else {
            this.elementText.getParent().setToolTipText(null);
            this.elementText.setToolTipText(null);
            this.elementImage.setToolTipText(text);
        }
    }

    public void setImage(Image image) {
        if (image != this.elementImage.getImage()) {
            this.elementImage.setImage(image);
        }
    }

    public void setText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.elementText.getText())) {
            this.elementText.setText(text);
        }
    }

    public int getWidth() {
        int result = 2;
        if (this.elementImage.getImage() != null) {
            result += this.elementImage.computeSize((int)-1, (int)-1).x;
        }
        if (this.textVisible && this.elementText.getText().length() > 0) {
            result += this.elementText.computeSize((int)-1, (int)-1).x;
        }
        return result;
    }

    public void setTextVisible(boolean enabled) {
        if (this.textVisible == enabled) {
            return;
        }
        this.textVisible = enabled;
        GridData data = (GridData)this.textComposite.getLayoutData();
        data.exclude = !enabled;
        this.textComposite.setVisible(enabled);
        if (this.textVisible) {
            this.detailComposite.setTabList(new Control[]{this.textComposite});
        } else {
            this.detailComposite.setTabList(new Control[]{this.imageComposite});
        }
        if (this.hasFocus) {
            if (this.isTextVisible()) {
                this.textComposite.setFocus();
            } else {
                this.imageComposite.setFocus();
            }
        }
        this.updateSelection();
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setVisible(boolean visible) {
        this.detailComposite.setVisible(visible);
        GridData data = (GridData)this.detailComposite.getLayoutData();
        data.exclude = !visible;
    }

    public void setSelected(boolean selected) {
        if (selected == this.selected) {
            return;
        }
        this.selected = selected;
        if (!this.selected) {
            this.hasFocus = false;
        }
        this.updateSelection();
    }

    public void setFocus(boolean enabled) {
        if (enabled == this.hasFocus) {
            return;
        }
        this.hasFocus = enabled;
        if (this.hasFocus) {
            if (this.isTextVisible()) {
                this.textComposite.setFocus();
            } else {
                this.imageComposite.setFocus();
            }
        }
        this.updateSelection();
    }

    private void updateSelection() {
        if (!StylingUtils.isStylingSupported()) {
            Color foreground;
            Color background;
            if (this.selected && this.hasFocus) {
                background = Display.getDefault().getSystemColor(26);
                foreground = Display.getDefault().getSystemColor(27);
            } else {
                foreground = null;
                background = null;
            }
            if (this.isTextVisible()) {
                this.textComposite.setBackground(background);
                this.elementText.setBackground(background);
                this.elementText.setForeground(foreground);
                this.imageComposite.setBackground(null);
                this.elementImage.setBackground(null);
            } else {
                this.imageComposite.setBackground(background);
                this.elementImage.setBackground(background);
                this.textComposite.setBackground(null);
                this.elementText.setBackground(null);
                this.elementText.setForeground(null);
            }
            this.textComposite.redraw();
            this.imageComposite.redraw();
        }
    }

    private void installFocusComposite(Composite composite) {
        composite.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    int index = BreadcrumbItemDetails.this.parent.getViewer().getIndexOfItem(BreadcrumbItemDetails.this.parent);
                    index = e.detail == 16 ? ++index : --index;
                    if (index > 0 && index < BreadcrumbItemDetails.this.parent.getViewer().getItemCount()) {
                        BreadcrumbItemDetails.this.parent.getViewer().selectItem(BreadcrumbItemDetails.this.parent.getViewer().getItem(index));
                    }
                    e.doit = true;
                }
            }
        });
        composite.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.parent.getViewer();
                switch (e.keyCode) {
                    case 0x1000003: {
                        if (BreadcrumbItemDetails.this.selected) {
                            viewer.doTraverse(false);
                            e.doit = false;
                            break;
                        }
                        viewer.selectItem(BreadcrumbItemDetails.this.parent);
                        break;
                    }
                    case 0x1000004: {
                        if (BreadcrumbItemDetails.this.selected) {
                            viewer.doTraverse(true);
                            e.doit = false;
                            break;
                        }
                        viewer.selectItem(BreadcrumbItemDetails.this.parent);
                        break;
                    }
                    case 0x1000002: 
                    case 16777259: {
                        if (!BreadcrumbItemDetails.this.selected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.parent);
                        }
                        this.openDropDown();
                        e.doit = false;
                        break;
                    }
                    case 13: {
                        if (!BreadcrumbItemDetails.this.selected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.parent);
                        }
                        viewer.fireOpen();
                        break;
                    }
                    default: {
                        if (e.character != ' ') break;
                        if (!BreadcrumbItemDetails.this.selected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.parent);
                        }
                        this.openDropDown();
                        e.doit = false;
                    }
                }
            }

            private void openDropDown() {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.parent.getViewer();
                int index = viewer.getIndexOfItem(BreadcrumbItemDetails.this.parent);
                BreadcrumbItem parent = BreadcrumbItemDetails.this.parent.getViewer().getItem(index - 1);
                parent.openDropDownMenu();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        composite.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!BreadcrumbItemDetails.this.hasFocus) {
                    BreadcrumbItemDetails.this.hasFocus = true;
                    BreadcrumbItemDetails.this.updateSelection();
                }
            }

            public void focusLost(FocusEvent e) {
                if (BreadcrumbItemDetails.this.hasFocus) {
                    BreadcrumbItemDetails.this.hasFocus = false;
                    BreadcrumbItemDetails.this.updateSelection();
                }
            }
        });
    }

    private void addElementListener(Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.parent.getViewer();
                int parentIndex = viewer.getIndexOfItem(BreadcrumbItemDetails.this.parent) - 1;
                Shell shell = null;
                if (parentIndex >= 0) {
                    BreadcrumbItem dropDownItem = viewer.getItem(parentIndex);
                    shell = dropDownItem.getDropDownShell();
                }
                viewer.selectItem(BreadcrumbItemDetails.this.parent);
                if (shell == null && e.button == 1 && e.stateMask == 0) {
                    BreadcrumbItemDetails.this.parent.getViewer().fireDoubleClick();
                }
            }
        });
        control.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.parent.getViewer();
                viewer.selectItem(BreadcrumbItemDetails.this.parent);
                BreadcrumbItemDetails.this.parent.getViewer().fireMenuDetect(e);
            }
        });
    }
}

