/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.config;

import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayModeLookupStrategy;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class DefaultDisplayModeOrdering
implements DisplayModeLookupStrategy {
    private static final ImList<DisplayMode> NORMAL_ORDERING = ImCollections.newList((Object)((Object)DisplayMode.NORMAL));
    private static final ImList<DisplayMode> HOVER_ORDERING = ImCollections.newList((Object[])new DisplayMode[]{DisplayMode.HOVER, DisplayMode.NORMAL});
    private static final ImList<DisplayMode> SELECT_ORDERING = ImCollections.newList((Object[])new DisplayMode[]{DisplayMode.SELECTED, DisplayMode.NORMAL});
    private static final ImList<DisplayMode> EDIT_ORDERING = ImCollections.newList((Object[])new DisplayMode[]{DisplayMode.EDIT, DisplayMode.NORMAL});
    private static final ImList<DisplayMode> EMPTY_ORDERING = ImCollections.emptyList();

    @Override
    public ImList<DisplayMode> getDisplayModeOrdering(DisplayMode targetDisplayMode) {
        switch (targetDisplayMode) {
            case NORMAL: {
                return NORMAL_ORDERING;
            }
            case HOVER: {
                return HOVER_ORDERING;
            }
            case SELECTED: {
                return SELECT_ORDERING;
            }
            case EDIT: {
                return EDIT_ORDERING;
            }
        }
        return EMPTY_ORDERING;
    }
}

