/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import java.util.Collection;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class ForwardLayerDim<TLayer extends Layer>
extends AbstractLayerDim<TLayer> {
    protected final LayerDim underlyingDim;

    public ForwardLayerDim(TLayer layer, LayerDim underlyingDim) {
        this(layer, underlyingDim.getOrientation(), underlyingDim);
    }

    public ForwardLayerDim(TLayer layer, Orientation orientation, LayerDim underlyingDim) {
        super(layer, orientation);
        this.underlyingDim = (LayerDim)ObjectUtils.nonNullAssert((Object)underlyingDim);
    }

    @Override
    public long getPositionId(long refPosition, long position) {
        return this.underlyingDim.getPositionId(refPosition, position);
    }

    @Override
    public long getPositionById(long id) {
        return this.underlyingDim.getPositionById(id);
    }

    @Override
    public long getPositionCount() {
        return this.underlyingDim.getPositionCount();
    }

    @Override
    public long localToUnderlyingPosition(long refPosition, long position) {
        return position;
    }

    @Override
    public long underlyingToLocalPosition(LayerDim sourceUnderlyingDim, long underlyingPosition) {
        if (sourceUnderlyingDim != this.underlyingDim) {
            throw new IllegalArgumentException("underlyingLayer");
        }
        return underlyingPosition;
    }

    @Override
    public List<LRange> underlyingToLocalPositions(LayerDim sourceUnderlyingDim, Collection<LRange> underlyingPositions) {
        if (sourceUnderlyingDim != this.underlyingDim) {
            throw new IllegalArgumentException("underlyingLayer");
        }
        return LRangeList.toRangeList(underlyingPositions);
    }

    @Override
    public ImList<LayerDim> getUnderlyingDimsByPosition(long position) {
        return ImCollections.newList((Object)this.underlyingDim);
    }

    @Override
    public long getSize() {
        return this.underlyingDim.getSize();
    }

    @Override
    public long getPreferredSize() {
        return this.underlyingDim.getPreferredSize();
    }

    @Override
    public long getPositionByPixel(long pixel) {
        return this.underlyingDim.getPositionByPixel(pixel);
    }

    @Override
    public long getPositionStart(long refPosition, long position) {
        return this.underlyingDim.getPositionStart(refPosition, position);
    }

    @Override
    public long getPositionStart(long position) {
        return this.underlyingDim.getPositionStart(position);
    }

    @Override
    public int getPositionSize(long refPosition, long position) {
        return this.underlyingDim.getPositionSize(refPosition, position);
    }

    @Override
    public int getPositionSize(long position) {
        return this.underlyingDim.getPositionSize(position);
    }

    @Override
    public boolean isPositionResizable(long position) {
        return this.underlyingDim.isPositionResizable(position);
    }
}

