/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.edit.ActiveCellEditorRegistry;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.EditMode;
import org.eclipse.statet.ecommons.waltable.edit.EditTypeEnum;
import org.eclipse.statet.ecommons.waltable.edit.InlineEditHandler;
import org.eclipse.statet.ecommons.waltable.edit.UpdateDataCommand;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.gui.CellEditDialogFactory;
import org.eclipse.statet.ecommons.waltable.edit.gui.ICellEditDialog;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditController {
    public static void editCell(LayerCell cell, Composite parent, Object initialCanonicalValue, ConfigRegistry configRegistry) {
        try {
            LRectangle cellBounds = cell.getBounds();
            Layer layer = cell.getLayer();
            long columnPosition = cell.getColumnPosition();
            long rowPosition = cell.getRowPosition();
            List<String> configLabels = cell.getLabels().getLabels();
            ICellEditor cellEditor = configRegistry.getAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, configLabels);
            if (cellEditor.openInline(configRegistry, configLabels)) {
                InlineEditHandler editHandler = new InlineEditHandler(layer, columnPosition, rowPosition);
                Rectangle editorBounds = SwtUtils.toSWT(layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, new LRectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height)));
                cellEditor.activateCell(parent, initialCanonicalValue, EditMode.INLINE, editHandler, cell, configRegistry);
                Control editorControl = cellEditor.getEditorControl();
                editorBounds = cellEditor.calculateControlBounds(editorBounds);
                if (editorControl != null && !editorControl.isDisposed()) {
                    editorControl.setBounds(editorBounds);
                    cellEditor.addEditorControlListeners();
                    ActiveCellEditorRegistry.registerActiveCellEditor(cellEditor);
                }
            } else {
                ArrayList<LayerCell> cells = new ArrayList<LayerCell>();
                cells.add(cell);
                EditController.editCells(cells, parent, initialCanonicalValue, configRegistry);
            }
        }
        catch (Exception e) {
            if (cell == null) {
                WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Cell being edited is no longer available. Initial value: " + initialCanonicalValue, (Throwable)e));
            }
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Error while editing cell: Cell: " + cell + "; Initial value: " + initialCanonicalValue, (Throwable)e));
        }
    }

    public static void editCells(Collection<LayerCell> cells, Composite parent, Object initialCanonicalValue, ConfigRegistry configRegistry) {
        block3: {
            ICellEditor cellEditor;
            block4: {
                if (cells == null || cells.isEmpty()) break block3;
                cellEditor = configRegistry.getAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, cells.iterator().next().getLabels().getLabels());
                if (cells.size() != 1 && (cells.size() <= 1 || !EditController.supportMultiEdit(cells, cellEditor, configRegistry))) break block3;
                if (!cellEditor.openMultiEditDialog()) break block4;
                ICellEditDialog dialog = CellEditDialogFactory.createCellEditDialog(parent != null ? parent.getShell() : null, initialCanonicalValue, cells.iterator().next(), cellEditor, configRegistry);
                int returnValue = dialog.open();
                if (returnValue != 0) break block3;
                for (LayerCell selectedCell : cells) {
                    Object editorValue = dialog.getCommittedValue();
                    if (dialog.getEditType() != EditTypeEnum.SET) {
                        editorValue = dialog.calculateValue(selectedCell.getDataValue(0, null), editorValue);
                    }
                    Layer layer = selectedCell.getLayer();
                    layer.doCommand(new UpdateDataCommand(layer, selectedCell.getColumnPosition(), selectedCell.getRowPosition(), editorValue));
                }
                break block3;
            }
            for (LayerCell cell : cells) {
                InlineEditHandler editHandler = new InlineEditHandler(cell.getLayer(), cell.getColumnPosition(), cell.getRowPosition());
                cellEditor.activateCell(parent, initialCanonicalValue, EditMode.INLINE, editHandler, cell, configRegistry);
            }
        }
    }

    private static boolean supportMultiEdit(Collection<LayerCell> cells, ICellEditor cellEditor, ConfigRegistry configRegistry) {
        for (LayerCell cell : cells) {
            if (cellEditor.supportMultiEdit(configRegistry, cell.getLabels().getLabels())) continue;
            return false;
        }
        return true;
    }
}

