/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit;

import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Composite;

public class InlineCellEditEvent
implements LayerEvent {
    private Layer layer;
    private final PositionCoordinate cellCoordinate;
    private final Composite parent;
    private final ConfigRegistry configRegistry;
    private final Object initialValue;

    public InlineCellEditEvent(Layer layer, PositionCoordinate cellCoordinate, Composite parent, ConfigRegistry configRegistry, Object initialValue) {
        this.layer = layer;
        this.cellCoordinate = cellCoordinate;
        this.parent = parent;
        this.configRegistry = configRegistry;
        this.initialValue = initialValue;
    }

    @Override
    public @Nullable InlineCellEditEvent toLayer(Layer targetLayer) {
        InlineCellEditEvent event = new InlineCellEditEvent(this.layer, new PositionCoordinate(this.cellCoordinate), this.parent, this.configRegistry, this.initialValue);
        return event.convertToLocal(targetLayer) ? event : null;
    }

    private boolean convertToLocal(Layer localLayer) {
        this.cellCoordinate.columnPosition = localLayer.getDim(Orientation.HORIZONTAL).underlyingToLocalPosition(this.layer.getDim(Orientation.HORIZONTAL), this.cellCoordinate.columnPosition);
        if (this.cellCoordinate.columnPosition < 0L || this.cellCoordinate.columnPosition >= localLayer.getColumnCount()) {
            return false;
        }
        this.cellCoordinate.rowPosition = localLayer.getDim(Orientation.VERTICAL).underlyingToLocalPosition(this.layer.getDim(Orientation.VERTICAL), this.cellCoordinate.rowPosition);
        if (this.cellCoordinate.rowPosition < 0L || this.cellCoordinate.rowPosition >= localLayer.getRowCount()) {
            return false;
        }
        this.layer = localLayer;
        return true;
    }

    public long getColumnPosition() {
        return this.cellCoordinate.columnPosition;
    }

    public long getRowPosition() {
        return this.cellCoordinate.rowPosition;
    }

    public Composite getParent() {
        return this.parent;
    }

    public ConfigRegistry getConfigRegistry() {
        return this.configRegistry;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }
}

