/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.statet.ecommons.waltable.edit.editor.TextCellEditor;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultiLineTextCellEditor
extends TextCellEditor {
    private boolean lineWrap = true;

    public MultiLineTextCellEditor() {
        this(true);
    }

    public MultiLineTextCellEditor(boolean lineWrap) {
        this.commitOnEnter = false;
        this.lineWrap = lineWrap;
    }

    @Override
    public Text createEditorControl(Composite parent) {
        boolean openInline = this.openInline(this.configRegistry, this.labelStack.getLabels());
        int style = CellStyleUtil.getHorizontalAlignmentSWT(this.cellStyle, 0) | 2 | 0x800;
        if (!openInline) {
            style |= 0x200;
        }
        if (this.lineWrap) {
            style |= 0x40;
        } else if (!openInline) {
            style |= 0x100;
        }
        final Text textControl = super.createEditorControl(parent, style);
        if (!openInline) {
            GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo((Control)textControl);
        }
        if (openInline) {
            this.commitOnEnter = true;
            textControl.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent event) {
                    if ((event.keyCode == 13 || event.keyCode == 0x1000050) && event.stateMask == 65536) {
                        textControl.insert(textControl.getLineDelimiter());
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
        }
        return textControl;
    }

    @Override
    public Rectangle calculateControlBounds(final Rectangle cellBounds) {
        Point size = this.getEditorControl().computeSize(-1, -1);
        this.getEditorControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Point p = MultiLineTextCellEditor.this.getEditorControl().computeSize(-1, -1, true);
                Point loc = MultiLineTextCellEditor.this.getEditorControl().getLocation();
                MultiLineTextCellEditor.this.getEditorControl().setBounds(loc.x, loc.y, Math.max(p.x, cellBounds.width), Math.max(p.y, cellBounds.height));
            }
        });
        return new Rectangle(cellBounds.x, cellBounds.y, Math.max(size.x, cellBounds.width), Math.max(size.y, cellBounds.height));
    }

    public void setLineWrap(boolean lineWrap) {
        this.lineWrap = lineWrap;
    }
}

