/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.swt;

import java.util.function.Function;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.swt.painters.GridLineCellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

@NonNullByDefault
public class CornerGridLineCellLayerPainter
extends GridLineCellLayerPainter {
    public CornerGridLineCellLayerPainter(Function<ConfigRegistry, Color> gridLineColorSupplier) {
        super(gridLineColorSupplier);
    }

    public CornerGridLineCellLayerPainter() {
    }

    private Layer getCornerLayer(Layer layer) {
        return layer.getUnderlyingLayerByPosition(0L, 0L).getUnderlyingLayerByPosition(0L, 0L);
    }

    @Override
    protected void drawHorizontalLines(Layer natLayer, GC gc, Rectangle rectangle) {
        LayerDim hDim = natLayer.getDim(Orientation.HORIZONTAL);
        int startX = GraphicsUtils.safe((long)rectangle.x + hDim.getPositionStart(this.getCornerLayer(natLayer).getColumnCount() - 1L) - 1L);
        int endX = GraphicsUtils.safe((long)rectangle.x + Math.min(hDim.getSize() - 1L, (long)rectangle.width));
        LayerDim dim = natLayer.getDim(Orientation.VERTICAL);
        long lastPosition = CornerGridLineCellLayerPainter.getEndPosition(dim, rectangle.y + rectangle.height) - 1L;
        if (startX < endX) {
            long position = dim.getPositionByPixel(rectangle.y);
            while (position < lastPosition) {
                int size = dim.getPositionSize(position);
                if (size > 0) {
                    int y = GraphicsUtils.safe(dim.getPositionStart(position) + (long)dim.getPositionSize(position) - 1L);
                    gc.drawLine(startX, y, endX, y);
                }
                ++position;
            }
        }
        int y = GraphicsUtils.safe(dim.getPositionStart(lastPosition) + (long)dim.getPositionSize(lastPosition) - 1L);
        gc.drawLine(GraphicsUtils.safe(rectangle.x), y, endX, y);
    }

    @Override
    protected void drawVerticalLines(Layer natLayer, GC gc, Rectangle rectangle) {
        LayerDim vDim = natLayer.getDim(Orientation.VERTICAL);
        int startY = GraphicsUtils.safe((long)rectangle.y + vDim.getPositionStart(this.getCornerLayer(natLayer).getRowCount() - 1L) - 1L);
        int endY = GraphicsUtils.safe((long)rectangle.y + Math.min(vDim.getSize() - 1L, (long)rectangle.height));
        LayerDim dim = natLayer.getDim(Orientation.HORIZONTAL);
        long lastPosition = CornerGridLineCellLayerPainter.getEndPosition(dim, rectangle.x + rectangle.width) - 1L;
        if (startY < endY) {
            long position = dim.getPositionByPixel(rectangle.x);
            while (position < lastPosition) {
                int size = dim.getPositionSize(position);
                if (size > 0) {
                    int x = GraphicsUtils.safe(dim.getPositionStart(position) + (long)size - 1L);
                    gc.drawLine(x, startY, x, endY);
                }
                ++position;
            }
        }
        int x = GraphicsUtils.safe(dim.getPositionStart(lastPosition) + (long)dim.getPositionSize(lastPosition) - 1L);
        gc.drawLine(x, GraphicsUtils.safe(rectangle.y), x, endY);
    }
}

