/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.action;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellPainter;
import org.eclipse.statet.ecommons.waltable.core.layer.top.OverlayPainter;
import org.eclipse.statet.ecommons.waltable.ui.action.IDragMode;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class CellDragMode
implements IDragMode {
    private MouseEvent initialEvent;
    private MouseEvent currentEvent;
    private int xOffset;
    private int yOffset;
    private Image cellImage;
    protected CellImageOverlayPainter cellImageOverlayPainter = new CellImageOverlayPainter();

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        this.currentEvent = this.initialEvent = event;
        this.setCellImage(natTable);
        natTable.forceFocus();
        natTable.addOverlayPainter(this.cellImageOverlayPainter);
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        this.currentEvent = event;
        natTable.redraw();
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        natTable.removeOverlayPainter(this.cellImageOverlayPainter);
        this.cellImage.dispose();
        natTable.redraw();
    }

    protected MouseEvent getInitialEvent() {
        return this.initialEvent;
    }

    protected MouseEvent getCurrentEvent() {
        return this.currentEvent;
    }

    private void setCellImage(NatTable natTable) {
        ImageData imageData;
        long columnPosition = natTable.getColumnPositionByX(this.currentEvent.x);
        long rowPosition = natTable.getRowPositionByY(this.currentEvent.y);
        LayerCell cell = natTable.getCellByPosition(columnPosition, rowPosition);
        LRectangle cellBounds = cell.getBounds();
        int width = (int)Math.min(cellBounds.width, 8191L);
        int height = (int)Math.min(cellBounds.height, 8191L);
        this.xOffset = (int)Math.max((long)this.currentEvent.x - cellBounds.x, 0L);
        this.yOffset = (int)Math.max((long)this.currentEvent.y - cellBounds.y, 0L);
        Image image = new Image((Device)natTable.getDisplay(), width, height);
        try {
            GC gc = new GC((Drawable)image);
            try {
                ConfigRegistry configRegistry = natTable.getConfigRegistry();
                LayerCellPainter layerCellPainter = configRegistry.getAttribute(CellConfigAttributes.CELL_PAINTER, cell.getDisplayMode(), cell.getLabels().getLabels());
                if (layerCellPainter != null) {
                    layerCellPainter.paintCell(cell, gc, new LRectangle(0L, 0L, width, height), configRegistry);
                }
            }
            finally {
                gc.dispose();
            }
            imageData = image.getImageData();
            imageData.alpha = 150;
        }
        finally {
            image.dispose();
        }
        this.cellImage = new Image((Device)natTable.getDisplay(), imageData);
    }

    private class CellImageOverlayPainter
    implements OverlayPainter {
        private CellImageOverlayPainter() {
        }

        @Override
        public void paintOverlay(GC gc, Layer layer) {
            if (CellDragMode.this.cellImage != null & !CellDragMode.this.cellImage.isDisposed()) {
                gc.drawImage(CellDragMode.this.cellImage, CellDragMode.this.currentEvent.x - CellDragMode.this.xOffset, CellDragMode.this.currentEvent.y - CellDragMode.this.yOffset);
            }
        }
    }
}

