/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core;

import java.util.Objects;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectDef;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.Immutable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.issues.core.Issues;
import org.eclipse.statet.ltk.issues.core.TaskTag;

@NonNullByDefault
public class TaskIssueConfig
implements Immutable {
    private final ImList<TaskTag> taskTags;
    private static final PreferenceObjectDef<TaskIssueConfig> CONFIG_PREF_FACTORY = PreferenceObjectDef.createFactory(TaskIssueConfig.class, (ImSet)ImCollections.newSet((Object)"org.eclipse.statet.ide.core/managment"), TaskIssueConfig::new);

    public TaskIssueConfig(ImList<TaskTag> taskTags) {
        this.taskTags = taskTags;
    }

    public TaskIssueConfig(PreferenceAccess prefs) {
        this.taskTags = Issues.loadTaskTags(prefs, Issues.TASK_TAG_KEYWORD_PREF, Issues.TASK_TAG_PRIORITY_PREF);
    }

    public ImList<TaskTag> getTaskTags() {
        return this.taskTags;
    }

    public @Nullable TaskTag getDefaultTaskTag() {
        return !this.taskTags.isEmpty() ? (TaskTag)this.taskTags.get(0) : null;
    }

    public int hashCode() {
        return this.taskTags.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TaskIssueConfig) {
            TaskIssueConfig other = (TaskIssueConfig)obj;
            return this.taskTags.equals(other.getTaskTags()) && Objects.equals(this.getDefaultTaskTag(), other.getDefaultTaskTag());
        }
        return super.equals(obj);
    }

    public static TaskIssueConfig getConfig(PreferenceAccess prefs) {
        return (TaskIssueConfig)PreferenceUtils.getPreferenceObject((PreferenceAccess)prefs, CONFIG_PREF_FACTORY);
    }
}

