/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.build;

import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.ModelManager;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;

@NonNullByDefault
public abstract class SourceUnitModelContainer<TSourceUnit extends SourceUnit, TModelInfo extends SourceUnitModelInfo> {
    private final TSourceUnit unit;
    private @Nullable AstInfo astInfo;
    private @Nullable TModelInfo modelInfo;
    private final @Nullable SourceUnitIssueSupport issueSupport;

    public SourceUnitModelContainer(TSourceUnit unit, @Nullable SourceUnitIssueSupport issueSupport) {
        this.unit = unit;
        this.issueSupport = issueSupport;
    }

    public abstract Class<?> getAdapterClass();

    public abstract boolean isContainerFor(String var1);

    protected @Nullable WorkingContext getMode(TSourceUnit su) {
        if (su instanceof WorkspaceSourceUnit) {
            return su.getWorkingContext();
        }
        return null;
    }

    public TSourceUnit getSourceUnit() {
        return this.unit;
    }

    public SourceContent getParseContent(IProgressMonitor monitor) {
        return this.unit.getContent(monitor);
    }

    public @Nullable AstInfo getAstInfo(boolean ensureSync, IProgressMonitor monitor) {
        if (ensureSync) {
            try {
                this.getModelManager().reconcile(this, 1, monitor);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }
        return this.astInfo;
    }

    public @Nullable TModelInfo getModelInfo(int syncLevel, IProgressMonitor monitor) {
        if ((syncLevel & 0x1000000) != 0) {
            this.clear();
        }
        if ((syncLevel & 0xF) >= 2) {
            @Nullable TModelInfo currentModel = this.modelInfo;
            if ((syncLevel & 0x2000000) != 0 || currentModel == null || currentModel.getStamp().getContentStamp() == 0L || currentModel.getStamp().getContentStamp() != this.unit.getContentStamp(monitor)) {
                try {
                    this.getModelManager().reconcile(this, syncLevel, monitor);
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        }
        return this.modelInfo;
    }

    protected abstract ModelManager getModelManager();

    public void clear() {
        this.astInfo = null;
        this.modelInfo = null;
    }

    public @Nullable AstInfo getCurrentAst() {
        if (this.unit.getWorkingContext() == Ltk.PERSISTENCE_CONTEXT) {
            @Nullable TModelInfo model = this.getCurrentModel();
            if (model != null) {
                return model.getAst();
            }
            return null;
        }
        return this.astInfo;
    }

    public void setAst(AstInfo ast) {
        if (this.unit.getWorkingContext() == Ltk.PERSISTENCE_CONTEXT) {
            return;
        }
        this.astInfo = ast;
    }

    public @Nullable TModelInfo getCurrentModel() {
        return this.modelInfo;
    }

    public void setModel(@Nullable TModelInfo modelInfo) {
        AstInfo astInfo;
        if (modelInfo != null && ((astInfo = this.astInfo) == null || astInfo.getStamp().equals(modelInfo.getAst().getStamp()))) {
            this.setAst(modelInfo.getAst());
        }
        this.modelInfo = modelInfo;
    }

    public @Nullable SourceUnitIssueSupport getIssueSupport() {
        return this.issueSupport;
    }
}

