/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.issues.core.impl.ResourceMarkerIssueRequestor;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public class ResourceIssueSupport
implements SourceUnitIssueSupport {
    private final IssueTypeSet issueTypeSet;

    public ResourceIssueSupport(IssueTypeSet issueTypeSet) {
        this.issueTypeSet = issueTypeSet;
    }

    @Override
    public IssueTypeSet getIssueTypeSet() {
        return this.issueTypeSet;
    }

    @Override
    public void clearIssues(SourceUnit sourceUnit) throws CoreException {
        ResourceMarkerIssueRequestor.clear(sourceUnit.getResource(), this.getIssueTypeSet());
    }

    @Override
    public @Nullable IssueRequestor createIssueRequestor(SourceUnit sourceUnit) {
        return ResourceMarkerIssueRequestor.create(sourceUnit.getResource(), this.getIssueTypeSet());
    }
}

