/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

class CompareUtilities {
    CompareUtilities() {
    }

    public static String readString(IStreamContentAccessor input) {
        try {
            String encoding = null;
            if (input instanceof IEncodedStreamContentAccessor) {
                encoding = ((IEncodedStreamContentAccessor)input).getCharset();
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return CompareUtilities.readString(input, encoding);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, "An error occurred when loading compare input.", (Throwable)e));
            return "";
        }
    }

    public static String readString(IStreamContentAccessor sca, String encoding) throws CoreException {
        String s = null;
        try {
            try {
                s = CompareUtilities.readString(sca.getContents(), encoding);
            }
            catch (UnsupportedEncodingException e) {
                if (!encoding.equals(ResourcesPlugin.getEncoding())) {
                    s = CompareUtilities.readString(sca.getContents(), ResourcesPlugin.getEncoding());
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, e.getMessage(), (Throwable)e));
        }
        return s;
    }

    public static String readString(InputStream is, String encoding) throws IOException {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            StringBuffer buffer = new StringBuffer();
            char[] part = new char[2048];
            int read = 0;
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

