/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingUtils;
import org.eclipse.statet.ecommons.runtime.core.util.PathUtils;
import org.eclipse.statet.ecommons.variables.core.DateVariable;
import org.eclipse.statet.ecommons.variables.core.DynamicVariable;
import org.eclipse.statet.ecommons.variables.core.TimeVariable;
import org.eclipse.statet.internal.nico.core.NicoCorePlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.NicoVariables;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.Prompt;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStatus;

@NonNullByDefault
public class ToolWorkspace {
    public static final int DETAIL_PROMPT = 1;
    public static final int DETAIL_LINE_SEPARTOR = 2;
    private final ToolProcess process;
    private volatile String lineSeparator;
    private volatile char fileSeparator;
    private volatile Prompt currentPrompt;
    private volatile Prompt defaultPrompt;
    private Prompt publishedPrompt;
    private @Nullable IFileStore workspaceDir;
    private final @Nullable String remoteHost;
    private @Nullable IPath remoteWorkspaceDirPath;
    private final Map<String, @Nullable Object> properties = new HashMap<String, Object>();
    private final CopyOnWriteIdentityListSet<Listener> propertyListener = new CopyOnWriteIdentityListSet();
    private boolean autoRefreshEnabled = true;
    private boolean isRefreshing;
    private final ImList<IDynamicVariable> stringVariables;
    private int changeFlags;

    public ToolWorkspace(ToolController controller, @Nullable Prompt prompt, String lineSeparator, char fileSeparator, @Nullable String remoteHost) {
        this.process = controller.getTool();
        if (prompt == null) {
            prompt = Prompt.DEFAULT;
        }
        this.currentPrompt = this.defaultPrompt = prompt;
        this.publishedPrompt = this.defaultPrompt;
        this.remoteHost = remoteHost;
        this.controlSetLineSeparator(lineSeparator);
        this.controlSetFileSeparator(fileSeparator);
        controller.addToolStatusListener(new ControllerListener());
        controller.getQueue().addOnIdle(new AutoUpdater(), 5000);
        this.stringVariables = ImCollections.newList((Object[])new IDynamicVariable[]{new DateVariable((IStringVariable)NicoVariables.SESSION_STARTUP_DATE_VARIABLE){

            protected long getTimestamp() {
                return ToolWorkspace.this.process.getStartupTimestamp();
            }
        }, new TimeVariable((IStringVariable)NicoVariables.SESSION_STARTUP_TIME_VARIABLE){

            protected long getTimestamp() {
                return ToolWorkspace.this.process.getStartupTimestamp();
            }
        }, new DateVariable((IStringVariable)NicoVariables.SESSION_CONNECTION_DATE_VARIABLE){

            protected long getTimestamp() {
                return ToolWorkspace.this.process.getConnectionTimestamp();
            }
        }, new TimeVariable((IStringVariable)NicoVariables.SESSION_CONNECTION_TIME_VARIABLE){

            protected long getTimestamp() {
                return ToolWorkspace.this.process.getStartupTimestamp();
            }
        }, new DynamicVariable.LocationVariable((IStringVariable)NicoVariables.SESSION_STARTUP_WD_VARIABLE){

            public String getValue(String argument) throws CoreException {
                return ToolWorkspace.this.process.getStartupWD();
            }
        }});
    }

    public ToolProcess getProcess() {
        return this.process;
    }

    public boolean isWindows() {
        return this.getFileSeparator() == '\\';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoRefresh(boolean enable) {
        Queue queue = this.process.getQueue();
        synchronized (queue) {
            if (this.autoRefreshEnabled != enable) {
                this.autoRefreshEnabled = enable;
                ToolStatus status = this.process.getToolStatus();
                if (status != ToolStatus.TERMINATED) {
                    if (enable && status.isWaiting()) {
                        this.process.getQueue().internal_resetOnIdle();
                        this.process.getQueue().notifyAll();
                    }
                    this.addPropertyChanged("AutoRefresh.enabled", enable);
                    this.firePropertiesChanged();
                }
            }
        }
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    protected void autoRefreshFromTool(ConsoleService service, ProgressMonitor m) throws StatusException {
        if (this.autoRefreshEnabled) {
            this.refreshFromTool(0, service, m);
        }
    }

    protected void refreshFromTool(int options, ConsoleService service, ProgressMonitor m) throws StatusException {
    }

    protected final int getChangeFlags() {
        return this.changeFlags;
    }

    protected void controlBriefChanged(@Nullable Object obj, int flags) {
        this.changeFlags |= flags;
    }

    protected void clearBriefedChanges() {
        this.changeFlags = 0;
    }

    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    public final char getFileSeparator() {
        return this.fileSeparator;
    }

    public final Prompt getPrompt() {
        return this.publishedPrompt;
    }

    protected final Prompt getCurrentPrompt() {
        return this.currentPrompt;
    }

    public final Prompt getDefaultPrompt() {
        return this.defaultPrompt;
    }

    public final @Nullable IFileStore getWorkspaceDir() {
        return this.workspaceDir;
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public final boolean isRemote() {
        return this.remoteHost != null;
    }

    public String getRemoteAddress() {
        return this.remoteHost;
    }

    public @Nullable IPath getRemoteWorkspaceDirPath() {
        return this.remoteWorkspaceDirPath;
    }

    public @Nullable IPath createToolPath(@Nullable String toolPath) {
        if (toolPath == null) {
            return null;
        }
        if (this.isWindows() && File.separatorChar == '/') {
            toolPath = toolPath.replace('\\', '/');
        }
        return PathUtils.check((IPath)new Path(toolPath));
    }

    public java.nio.file.Path toSystemPath(String toolPathString) throws StatusException {
        CoreException error = null;
        try {
            IFileStore fileStore = this.toFileStore(toolPathString);
            if (fileStore != null) {
                return java.nio.file.Path.of(fileStore.toURI());
            }
        }
        catch (CoreException e) {
            error = e;
        }
        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.nico.core", String.format("Cannot convert tool path '%1$s' to path of local system.", toolPathString), (Throwable)error));
    }

    public @Nullable IFileStore toFileStore(IPath toolPath) throws CoreException {
        if (this.remoteHost != null) {
            return ResourceMappingUtils.getManager().mapRemoteResourceToFileStore(this.remoteHost, toolPath, this.remoteWorkspaceDirPath != null ? this.remoteWorkspaceDirPath : null);
        }
        return FileUtil.getFileStore((String)toolPath.toString(), (IFileStore)this.workspaceDir);
    }

    public @Nullable IFileStore toFileStore(String toolPathString) throws CoreException {
        if (this.remoteHost != null) {
            IPath toolPath = this.createToolPath(toolPathString);
            if (toolPath != null) {
                return this.toFileStore(toolPath);
            }
            return null;
        }
        return FileUtil.getFileStore((String)toolPathString, (IFileStore)this.workspaceDir);
    }

    public String toToolPath(IFileStore fileStore) throws StatusException {
        if (this.remoteHost != null) {
            IPath path = ResourceMappingUtils.getManager().mapFileStoreToRemoteResource(this.remoteHost, fileStore);
            if (path != null) {
                return path.toString();
            }
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.nico.core", "Resolving path for the remote system failed."));
        }
        return URIUtil.toPath((URI)fileStore.toURI()).toString();
    }

    final void controlRefresh(int options, ConsoleService adapter, ProgressMonitor m) throws StatusException {
        this.isRefreshing = true;
        try {
            this.refreshFromTool(options, adapter, m);
        }
        finally {
            this.isRefreshing = false;
        }
        this.firePropertiesChanged();
    }

    final void controlSetCurrentPrompt(@Nullable Prompt prompt, ToolStatus status) {
        if (prompt == null || prompt == this.currentPrompt) {
            return;
        }
        this.currentPrompt = prompt;
        if (!status.isRunning()) {
            this.publishedPrompt = prompt;
            this.firePrompt(prompt, null);
        }
    }

    final void controlSetDefaultPrompt(@Nullable Prompt prompt) {
        if (prompt == this.defaultPrompt || prompt == null) {
            return;
        }
        Prompt oldDefault = this.defaultPrompt;
        this.defaultPrompt = prompt;
        if (oldDefault == this.currentPrompt) {
            this.currentPrompt = prompt;
        }
        if (oldDefault == this.publishedPrompt) {
            this.publishedPrompt = prompt;
            this.firePrompt(prompt, null);
        }
    }

    final void controlSetLineSeparator(@Nullable String newSeparator) {
        String oldSeparator = this.lineSeparator;
        this.lineSeparator = newSeparator != null ? newSeparator : (this.remoteHost == null ? System.lineSeparator() : "\n");
    }

    final void controlSetFileSeparator(char newSeparator) {
        char oldSeparator = this.fileSeparator;
        this.fileSeparator = newSeparator != '\u0000' ? newSeparator : (char)(this.isRemote() ? 47 : (int)File.separatorChar);
    }

    protected final void controlSetWorkspaceDir(@Nullable IFileStore directory) {
        if (!Objects.equals(this.workspaceDir, directory)) {
            this.workspaceDir = directory;
            this.properties.put("wd", directory);
            if (!this.isRefreshing) {
                this.firePropertiesChanged();
            }
        }
    }

    protected final void controlSetRemoteWorkspaceDir(IPath toolPath) {
        this.remoteWorkspaceDirPath = toolPath;
        try {
            this.controlSetWorkspaceDir(this.toFileStore(toolPath));
        }
        catch (CoreException e) {
            this.controlSetWorkspaceDir(null);
        }
    }

    private final void firePrompt(Prompt prompt, @Nullable List<DebugEvent> eventCollection) {
        DebugEvent event = new DebugEvent((Object)this, 16, 1);
        event.setData((Object)prompt);
        if (eventCollection != null) {
            eventCollection.add(event);
            return;
        }
        this.fireEvent(event);
    }

    protected final void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    public final void addPropertyListener(Listener listener) {
        this.propertyListener.add((Object)listener);
    }

    public final void removePropertyListener(Listener listener) {
        this.propertyListener.remove((Object)listener);
    }

    protected final void addPropertyChanged(String property, @Nullable Object value) {
        this.properties.put(property, value);
    }

    protected final void firePropertiesChanged() {
        if (this.properties.isEmpty()) {
            return;
        }
        for (Listener listener : this.propertyListener.toList()) {
            try {
                listener.propertyChanged(this, this.properties);
            }
            catch (Exception e) {
                NicoCorePlugin.logError(0, "An unexpected exception was thrown when notifying a tool workspace listener about changes.", e);
            }
        }
        this.properties.clear();
    }

    public ImList<IDynamicVariable> getStringVariables() {
        return this.stringVariables;
    }

    protected void dispose() {
    }

    private class AutoUpdater
    implements SystemRunnable {
        private AutoUpdater() {
        }

        public String getTypeId() {
            return "common/workspace/update.auto";
        }

        public String getLabel() {
            return "Auto Update";
        }

        public boolean canRunIn(Tool tool) {
            return tool == ToolWorkspace.this.process;
        }

        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 288: 
                case 289: {
                    return false;
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            ToolWorkspace.this.isRefreshing = true;
            try {
                ToolWorkspace.this.autoRefreshFromTool((ConsoleService)service, m);
            }
            finally {
                ToolWorkspace.this.isRefreshing = false;
            }
            ToolWorkspace.this.firePropertiesChanged();
        }
    }

    private class ControllerListener
    implements ToolController.IToolStatusListener {
        private ControllerListener() {
        }

        @Override
        public void controllerStatusChanged(ToolStatus oldStatus, ToolStatus newStatus, List<DebugEvent> eventCollection) {
            if (newStatus == ToolStatus.TERMINATED) {
                ToolWorkspace.this.dispose();
            }
            if (!newStatus.isRunning()) {
                if (ToolWorkspace.this.currentPrompt == null || ToolWorkspace.this.currentPrompt == ToolWorkspace.this.publishedPrompt) {
                    return;
                }
                ToolWorkspace.this.publishedPrompt = ToolWorkspace.this.currentPrompt;
                ToolWorkspace.this.firePrompt(ToolWorkspace.this.currentPrompt, eventCollection);
                return;
            }
            ToolWorkspace.this.publishedPrompt = ToolWorkspace.this.defaultPrompt;
            ToolWorkspace.this.firePrompt(ToolWorkspace.this.defaultPrompt, eventCollection);
        }
    }

    public static interface Listener {
        public void propertyChanged(ToolWorkspace var1, Map<String, @Nullable Object> var2);
    }
}

