/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public final class LocalTaskTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "org.eclipse.statet.nico-task-transfer-format" + Long.toString(System.currentTimeMillis());
    private static final int TYPEID = LocalTaskTransfer.registerType((String)TYPE_NAME);
    private static final LocalTaskTransfer INSTANCE = new LocalTaskTransfer();
    private @Nullable ToolProcess process;
    private @Nullable Data data;

    public static LocalTaskTransfer getTransfer() {
        return INSTANCE;
    }

    protected LocalTaskTransfer() {
    }

    private boolean isInvalidNativeType(Object result) {
        return !(result instanceof byte[]) || !TYPE_NAME.equals(new String((byte[])result));
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        this.data = (Data)object;
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative((Object)check, transferData);
    }

    public @Nullable Object nativeToJava(TransferData transferData) {
        Object result = super.nativeToJava(transferData);
        if (this.isInvalidNativeType(result)) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", 0, "invalid transfer type", null));
        }
        return this.data;
    }

    public void init(ToolProcess process) {
        this.process = process;
    }

    public @Nullable Data createData() {
        if (this.process != null) {
            return new Data(this.process);
        }
        return null;
    }

    public void finished() {
        this.process = null;
        this.data = null;
    }

    public @Nullable String getMainType() {
        if (this.process != null) {
            return this.process.getMainType();
        }
        return null;
    }

    public static class Data {
        public final ToolProcess process;
        public @Nullable ImList<ToolRunnable> runnables;

        private Data(ToolProcess process) {
            this.process = process;
        }
    }
}

