/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.swt.EnhStyledText;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

@NonNullByDefault
public class OutputViewer
extends TextConsoleViewer {
    private boolean autoScroll = true;
    private @Nullable IDocumentListener documentListener;

    public OutputViewer(Composite parent, TextConsole console) {
        super(parent, console);
        this.setEditable(false);
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean scroll) {
        this.autoScroll = scroll;
    }

    public void setDocument(@Nullable IDocument document) {
        IDocument oldDocument = this.getDocument();
        if (oldDocument != null) {
            oldDocument.removeDocumentListener(this.getDocumentListener());
        }
        super.setDocument(document);
        if (document != null) {
            document.addDocumentListener(this.getDocumentListener());
        }
    }

    private IDocumentListener getDocumentListener() {
        IDocumentListener documentListener = this.documentListener;
        if (documentListener == null) {
            this.documentListener = documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (OutputViewer.this.autoScroll) {
                        OutputViewer.this.revealEndOfDocument();
                    }
                }
            };
        }
        return documentListener;
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return EnhStyledText.forSourceEditor((Composite)parent, (int)styles);
    }

    public void revealEndOfDocument() {
        final Display display = UIAccess.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                final StyledText textWidget = OutputViewer.this.getTextWidget();
                if (textWidget == null || !UIAccess.isOkToUse((Control)textWidget)) {
                    return;
                }
                AbstractDocument document = (AbstractDocument)OutputViewer.this.getDocument();
                final long timestamp = document.getModificationStamp();
                int lineCount = textWidget.getLineCount();
                int lineToShow = lineCount > 1 && textWidget.getCharCount() == textWidget.getOffsetAtLine(lineCount - 1) ? lineCount - 1 : lineCount;
                int visiblePixel = textWidget.getClientArea().height;
                int linePixel = textWidget.getLineHeight();
                int topPixel = linePixel * (lineToShow - 1) - visiblePixel + 2;
                if (topPixel + linePixel > 0) {
                    if (topPixel < 0) {
                        textWidget.setTopPixel(topPixel + linePixel);
                    } else {
                        final int[] move = new int[]{topPixel, topPixel + linePixel - 2, topPixel + linePixel - 1, topPixel + linePixel};
                        textWidget.setTopPixel(move[0]);
                        final int[] state = new int[]{1};
                        display.timerExec(75, new Runnable(){

                            @Override
                            public void run() {
                                int i = state[0];
                                if (!UIAccess.isOkToUse((Control)textWidget) || timestamp != ((IDocumentExtension4)OutputViewer.this.getDocument()).getModificationStamp() || move[i - 1] != textWidget.getTopPixel()) {
                                    return;
                                }
                                textWidget.setTopPixel(move[i++]);
                                if (i < move.length) {
                                    state[0] = i;
                                    display.timerExec(25, (Runnable)this);
                                }
                            }
                        });
                    }
                }
            }
        });
    }
}

