/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.statet.internal.r.core.builder.RUnitElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RLangElement;

@NonNullByDefault
public class CompositeFrame
implements RFrame<RLangElement<?>> {
    private final int frameType;
    private final RElementName elementName;
    public final Map<String, RUnitElement> modelElements;
    private final Lock lock;

    public CompositeFrame(ReadWriteLock lock, @Nullable String packageName, String projectName, @Nullable Map<String, RUnitElement> elements) {
        this.lock = lock.readLock();
        HashMap hashMap = this.modelElements = elements != null ? elements : new HashMap();
        if (packageName != null) {
            this.frameType = 2;
            this.elementName = RElementName.create(38, packageName);
        } else {
            this.frameType = 1;
            this.elementName = RElementName.create(41, projectName);
        }
    }

    public CompositeFrame(ReadWriteLock lock, @Nullable String packageName, String projectName, CompositeFrame copyFrom) {
        this(lock, packageName, projectName, copyFrom.modelElements);
    }

    public CompositeFrame(ReadWriteLock lock, @Nullable String packageName, String projectName) {
        this(lock, packageName, projectName, (Map<String, RUnitElement>)null);
    }

    @Override
    public RElementName getElementName() {
        return this.elementName;
    }

    @Override
    public @Nullable String getFrameId() {
        return null;
    }

    @Override
    public int getFrameType() {
        return this.frameType;
    }

    @Override
    public List<? extends RLangElement<?>> getModelElements() {
        this.lock.lock();
        try {
            Collection<RUnitElement> values = this.modelElements.values();
            ArrayList<RUnitElement> list = new ArrayList<RUnitElement>(values.size());
            list.addAll(values);
            ArrayList<RUnitElement> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangElement<?>> filter) {
        this.lock.lock();
        try {
            if (this.modelElements.isEmpty()) {
                return false;
            }
            for (RUnitElement element : this.modelElements.values()) {
                if (!element.hasModelChildren(filter)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<? extends RLangElement<?>> getModelChildren(@Nullable LtkModelElementFilter<? super RLangElement<?>> filter) {
        this.lock.lock();
        try {
            if (this.modelElements.isEmpty()) {
                ImList imList = ImCollections.emptyList();
                return imList;
            }
            ArrayList<RLangElement> children = new ArrayList<RLangElement>();
            for (RLangElement rLangElement : this.modelElements.values()) {
                List elementChildren = rLangElement.getModelChildren(null);
                if (elementChildren.isEmpty()) continue;
                children.ensureCapacity(children.size() + elementChildren.size());
                for (RLangElement child : elementChildren) {
                    if (filter != null && !filter.include((LtkModelElement)child)) continue;
                    children.add(child);
                }
            }
            ArrayList<RLangElement> arrayList = children;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<? extends RFrame<?>> getPotentialParents() {
        return Collections.EMPTY_LIST;
    }

    public RUnitElement setModelElement(String suId, RUnitElement element) {
        element.envir = this;
        return this.modelElements.put(suId, element);
    }

    public RUnitElement removeModelElement(String suId) {
        return this.modelElements.remove(suId);
    }

    public void removeModelElements(String modelTypeId) {
        Iterator<RUnitElement> iter = this.modelElements.values().iterator();
        while (iter.hasNext()) {
            RUnitElement unitElement = iter.next();
            if (unitElement.getModelTypeId() != modelTypeId) continue;
            iter.remove();
        }
    }

    public String toString() {
        ObjectUtils.ToStringBuilder builder = new ObjectUtils.ToStringBuilder("CompositeFrame", this.getClass());
        builder.addProp("frameType", "0x%02X", new Object[]{this.frameType});
        builder.addProp("elementName", (Object)this.elementName);
        return builder.build();
    }
}

