/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.internal.r.core.rmodel.ProblemMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.model.core.AttachmentsElement;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AbstractAstProblemReporter;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.StatusDetail;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Arithmetic;
import org.eclipse.statet.r.core.source.ast.Assignment;
import org.eclipse.statet.r.core.source.ast.Block;
import org.eclipse.statet.r.core.source.ast.CForLoop;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.CLoopCommand;
import org.eclipse.statet.r.core.source.ast.CRepeatLoop;
import org.eclipse.statet.r.core.source.ast.CWhileLoop;
import org.eclipse.statet.r.core.source.ast.Dummy;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.Group;
import org.eclipse.statet.r.core.source.ast.Help;
import org.eclipse.statet.r.core.source.ast.Logical;
import org.eclipse.statet.r.core.source.ast.Model;
import org.eclipse.statet.r.core.source.ast.NSGet;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.NullConst;
import org.eclipse.statet.r.core.source.ast.NumberConst;
import org.eclipse.statet.r.core.source.ast.Pipe;
import org.eclipse.statet.r.core.source.ast.Placeholder;
import org.eclipse.statet.r.core.source.ast.Power;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.Relational;
import org.eclipse.statet.r.core.source.ast.Seq;
import org.eclipse.statet.r.core.source.ast.Sign;
import org.eclipse.statet.r.core.source.ast.SourceComponent;
import org.eclipse.statet.r.core.source.ast.Special;
import org.eclipse.statet.r.core.source.ast.StringConst;
import org.eclipse.statet.r.core.source.ast.SubIndexed;
import org.eclipse.statet.r.core.source.ast.SubNamed;
import org.eclipse.statet.r.core.source.ast.Symbol;

@NonNullByDefault
public class AstProblemReporter
extends AbstractAstProblemReporter {
    private final Visitor visitor = new Visitor();

    public AstProblemReporter() {
        super("R");
    }

    public void run(RAstNode node, SourceContent content, IssueRequestor requestor) {
        try {
            try {
                this.init(content, requestor);
                node.acceptInR(this.visitor);
                this.flush();
            }
            catch (InvocationTargetException | OperationCanceledException throwable) {
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void handleCommonCodes(RAstNode node, int code) throws BadLocationException, InvocationTargetException {
        switch (code & 0x700FF0) {
            case 4194720: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_TokenUnexpected_message, (Object)this.getMessageUtil().getFullText((AstNode)node)), node.getStartOffset(), node.getEndOffset());
                return;
            }
            case 4194736: {
                switch (code & 0xFF000) {
                    case 32768: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ExprUnexpected_FCallAfterPipeExpected_message, node.getStartOffset(), node.getEndOffset());
                        return;
                    }
                }
                break;
            }
        }
        super.handleCommonCodes((AstNode)node, code);
    }

    private void handleTextInvalid(RAstNode node, int code) throws BadLocationException {
        StatusDetail detail = StatusDetail.getStatusDetail((AttachmentsElement)node);
        switch (code & 0x700FFF) {
            case 4194673: {
                this.addProblem(2, code, ProblemMessages.Syntax_String_NullCharNotAllowed_message, detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 4194677: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_String_EscapeSeqHexDigitMissing_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 4194676: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_String_EscapeSeqNotClosed_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 4194675: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_String_QuotedSymbol_EscapeSeqUnexpected_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 4194681: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_String_EscapeSeqUnknown_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 4194683: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_String_CodePointInvalid_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
        }
        this.handleUnknownCodes(node);
    }

    private class Visitor
    extends RAstVisitor {
        private final RValueFormatter valueFormatter = new RValueFormatter();

        private Visitor() {
        }

        @Override
        public void visit(SourceComponent node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Block node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 4195600: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_BlockNotClosed_message, node.getEndOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Group node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 4195600: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_GroupNotClosed_message, node.getEndOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(CIfElse node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 4195632: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_IfOfElseMissing_message, node.getStartOffset(), node.getStartOffset() + 1);
                            break;
                        }
                        case 0x400540: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ConditionMissing_If_message, node.getStartOffset() + 1, node.getStartOffset() + 3);
                            break;
                        }
                        case 4195680: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ConditionNotClosed_If_message, node.getCondChild().getEndOffset() - 1, node.getCondChild().getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(CForLoop node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 0x400540: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ConditionMissing_For_message, node.getStartOffset() + 2, node.getStartOffset() + 4);
                            break;
                        }
                        case 4195680: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ConditionNotClosed_For_message, node.getCondChild().getEndOffset() - 1, node.getCondChild().getEndOffset() + 1);
                            break;
                        }
                        case 0x400550: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_InOfForConditionMissing_message, node.getVarChild().getEndOffset() - 1, node.getVarChild().getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(CRepeatLoop node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(CWhileLoop node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 0x400540: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ConditionMissing_While_message, node.getStartOffset() + 4, node.getStartOffset() + 6);
                            break;
                        }
                        case 4195680: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ConditionNotClosed_While_message, node.getCondChild().getEndOffset() - 1, node.getCondChild().getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(CLoopCommand node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(FCall node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 0x400410: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FcallArgsNotClosed_message, node.getArgsChild().getEndOffset() - 1, node.getArgsChild().getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(FCall.Args node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(FCall.Arg node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(FDef node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7FFFF0) {
                        case 4220688: {
                            int offset = node.getArgsCloseOffset();
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FdefShorthandUnsupported_message, node.getStartOffset(), offset != Integer.MIN_VALUE ? offset + 1 : node.getArgsChild().getEndOffset());
                            break;
                        }
                        case 4195856: {
                            int offset = node.getStartOffset() + node.getOperator((int)0).text.length();
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FdefArgsMissing_message, offset - 1, offset + 1);
                            break;
                        }
                        case 4195872: {
                            int offset = node.getArgsChild().getEndOffset();
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FdefArgsNotClosed_message, offset - 1, offset + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(FDef.Args node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(FDef.Arg node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Assignment node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Pipe node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7FFFF0) {
                        case 4228880: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_PipeRightUnsupported_message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Model node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Relational node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FFF) {
                        case 4194731: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_TokenUnexpected_SeqRel_message, (Object)node.getOperator((int)0).text), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Logical node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Arithmetic node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Power node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Seq node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Special node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 4194592: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_SpecialNotClosed_message, (Object)this.valueFormatter.escapeString(AstProblemReporter.this.getMessageUtil().getStartText((AstNode)node, 1))), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Sign node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(SubIndexed node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 0x400410: {
                            if (node.getNodeType() == NodeType.SUB_INDEXED_S) {
                                AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_SubindexedNotClosed_S_message, (Object)AstProblemReporter.this.getMessageUtil().getStartText((AstNode)node, 0)), node.getEndOffset() - 1, node.getEndOffset() + 1);
                                break;
                            }
                            if (node.getSublistCloseOffset() != Integer.MIN_VALUE) {
                                AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_SubindexedNotClosed_Done_message, (Object)AstProblemReporter.this.getMessageUtil().getStartText((AstNode)node, 0)), node.getEndOffset() - 1, node.getEndOffset() + 1);
                                break;
                            }
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_SubindexedNotClosed_Dboth_message, (Object)AstProblemReporter.this.getMessageUtil().getStartText((AstNode)node, 0)), node.getEndOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(SubIndexed.Args node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(SubIndexed.Arg node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(SubNamed node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(NSGet node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(StringConst node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 0x400110: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_StringROpeningIncomplete_message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4194592: {
                            AstProblemReporter.this.addProblem(2, code, node.getOperator(0) == RTerminal.STRING_R ? AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_StringRNotClosed_message, (Object)this.valueFormatter.escapeString(AstProblemReporter.this.getMessageUtil().getStartText((AstNode)node, 1)), (Object)StatusDetail.getStatusDetail((AttachmentsElement)node).getText()) : AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_StringNotClosed_message, (Object)this.valueFormatter.escapeString(AstProblemReporter.this.getMessageUtil().getStartText((AstNode)node, 1)), (Object)node.getOperator((int)0).text), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4194672: {
                            AstProblemReporter.this.handleTextInvalid(node, code);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        @Override
        public void visit(NumberConst node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FFF) {
                        case 4194645: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Number_HexDigitMissing_message, (Object)AstProblemReporter.this.getMessageUtil().getFullText((AstNode)node)), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4194646: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Number_HexFloatExpMissing_message, (Object)AstProblemReporter.this.getMessageUtil().getFullText((AstNode)node)), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4194647: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Number_ExpDigitMissing_message, (Object)AstProblemReporter.this.getMessageUtil().getFullText((AstNode)node)), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 353: {
                            AstProblemReporter.this.addProblem(1, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Number_NonIntWithLLiteral_message, (Object)AstProblemReporter.this.getMessageUtil().getFullText((AstNode)node)), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 354: {
                            AstProblemReporter.this.addProblem(1, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Number_IntWithDecPoint_message, (Object)AstProblemReporter.this.getMessageUtil().getFullText((AstNode)node)), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        @Override
        public void visit(NullConst node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void visit(Symbol node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (!AstProblemReporter.this.requiredCheck(code)) return;
            try {
                switch (code & 0x700FF0) {
                    case 4194592: {
                        AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_QuotedSymbolNotClosed_message, (Object)this.valueFormatter.escapeString(AstProblemReporter.this.getMessageUtil().getStartText((AstNode)node, 1))), node.getEndOffset() - 1, node.getEndOffset() + 1);
                        return;
                    }
                    case 0x400140: {
                        switch (code & 0x700FFF) {
                            case 0x400141: {
                                StatusDetail detail = StatusDetail.getStatusDetail((AttachmentsElement)node);
                                AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_SymbolStartInvalid_message, (Object)this.valueFormatter.escapeString(AstProblemReporter.this.getMessageUtil().getStartText((AstNode)node, 0)), (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                                return;
                            }
                        }
                        break;
                    }
                    case 4194672: {
                        AstProblemReporter.this.handleTextInvalid(node, code);
                        return;
                    }
                    case 0x400330: {
                        AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_SymbolMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                        return;
                    }
                    case 4195104: {
                        AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ElementnameMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                        return;
                    }
                }
                AstProblemReporter.this.handleCommonCodes(node, code);
                return;
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(Placeholder node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    block1 : switch (code & 0x7FFFF0) {
                        case 4227488: {
                            switch (code & 0x700FFF) {
                                case 4194723: {
                                    AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_PipePlaceholderUnnamedUnexpected_message, node.getStartOffset(), node.getEndOffset());
                                    break block1;
                                }
                                case 4194722: {
                                    AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_PipePlaceholderMultipleUnexpected_message, node.getStartOffset(), node.getEndOffset());
                                    break block1;
                                }
                            }
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_PipePlaceholderUnexpected_message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4228880: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_PipePlaceholderUnsupported_message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        @Override
        public void visit(Help node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(Dummy node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    block1 : switch (code & 0x700FFF) {
                        case 4195090: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ExprBeforeOpMissing_message, AstProblemReporter.this.expandSpaceStart(node.getStartOffset()), node.getEndOffset() + 1);
                            break;
                        }
                        case 4195091: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_ExprAfterOpMissing_message, (Object)AstProblemReporter.this.getMessageUtil().getFullText((AstNode)node)), node.getStartOffset() - 1, AstProblemReporter.this.expandSpaceEnd(node.getEndOffset()));
                            break;
                        }
                        case 4195248: {
                            switch (code & 0xFF000) {
                                case 32768: {
                                    AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FCallAfterPipeMissing_message, node.getStartOffset() - 1, AstProblemReporter.this.expandSpaceEnd(node.getEndOffset()));
                                    break block1;
                                }
                            }
                            AstProblemReporter.this.handleUnknownCodes(node);
                            break;
                        }
                        case 4195092: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ExprAsConditionMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        case 4195093: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ExprAsForSequenceMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        case 4195094: {
                            String message;
                            switch (code & 0xFF000) {
                                case 4096: {
                                    message = ProblemMessages.Syntax_ExprAsThenBodyMissing_message;
                                    break;
                                }
                                case 8192: {
                                    message = ProblemMessages.Syntax_ExprAsElseBodyMissing_message;
                                    break;
                                }
                                case 12288: 
                                case 16384: 
                                case 20480: {
                                    message = ProblemMessages.Syntax_ExprAsLoopBodyMissing_message;
                                    break;
                                }
                                case 24576: {
                                    message = ProblemMessages.Syntax_ExprAsFdefBodyMissing_message;
                                    break;
                                }
                                default: {
                                    AstProblemReporter.this.handleUnknownCodes(node);
                                    break block1;
                                }
                            }
                            if (node.getLength() > 0) {
                                AstProblemReporter.this.addProblem(2, code, message, node.getStartOffset(), node.getEndOffset());
                                break;
                            }
                            AstProblemReporter.this.addProblem(2, code, message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        case 4195095: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ExprInGroupMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        case 4195096: {
                            if ((code & 0xFF000) == 24576) {
                                AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_ExprAsFdefArgDefaultMissing_message, node.getStartOffset() - 1, node.getEndOffset());
                                break;
                            }
                        }
                        default: {
                            switch (code & 0x700FF0) {
                                case 4194704: {
                                    AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_TokenUnknown_message, (Object)AstProblemReporter.this.getMessageUtil().getFullText((AstNode)node)), node.getStartOffset(), node.getEndOffset());
                                    break block1;
                                }
                                case 4195200: {
                                    if (node.getChildCount() == 2) {
                                        AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_OperatorMissing_message, node.getChild(0).getEndOffset() - 1, node.getChild(1).getStartOffset() + 1);
                                        break block1;
                                    }
                                    AstProblemReporter.this.handleUnknownCodes(node);
                                    break block1;
                                }
                            }
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInRChildren(this);
        }
    }
}

