/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rmodel.build;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.internal.r.core.rmodel.AstProblemReporter;
import org.eclipse.statet.internal.r.core.rmodel.RTaskTagReporter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;
import org.eclipse.statet.r.core.rmodel.RCompositeSourceElement;
import org.eclipse.statet.r.core.rmodel.RLangSourceElement;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.source.ast.RAstNode;

@NonNullByDefault
public class RIssueReporter {
    private final AstProblemReporter syntaxProblemReporter = new AstProblemReporter();
    private final RTaskTagReporter taskReporter = new RTaskTagReporter();
    private @Nullable TaskIssueConfig taskIssueConfig;
    private boolean runProblems;
    private boolean runTasks;

    public void configure(TaskIssueConfig taskIssueConfig) {
        this.taskIssueConfig = taskIssueConfig;
    }

    public void run(RSourceUnit sourceUnit, RSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        RLangSourceElement element;
        this.runProblems = requestor.isInterestedInProblems("R");
        this.runTasks = requestor.isInterestedInTasks();
        if (!this.runProblems && !this.runTasks) {
            return;
        }
        TaskIssueConfig taskIssueConfig = this.taskIssueConfig;
        if (taskIssueConfig == null) {
            PreferenceAccess prefs = EPreferences.getContextPrefs((IAdaptable)sourceUnit);
            taskIssueConfig = TaskIssueConfig.getConfig((PreferenceAccess)prefs);
        }
        if (this.runTasks) {
            this.taskReporter.configure(taskIssueConfig);
        }
        if ((element = modelInfo.getSourceElement()) instanceof RCompositeSourceElement) {
            List<? extends RLangSourceElement> elements = ((RCompositeSourceElement)element).getCompositeElements();
            for (RLangSourceElement rLangSourceElement : elements) {
                this.runReporters(sourceUnit, (AstNode)rLangSourceElement.getAdapter(AstNode.class), modelInfo, content, requestor, level);
            }
        } else {
            this.runReporters(sourceUnit, (AstNode)element.getAdapter(AstNode.class), modelInfo, content, requestor, level);
        }
    }

    public void run(RAstNode node, SourceContent content, IssueRequestor requestor, int level) {
        if (requestor.isInterestedInProblems("R")) {
            this.syntaxProblemReporter.run(node, content, requestor);
        }
    }

    private void runReporters(RSourceUnit sourceUnit, RAstNode node, @Nullable RSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        if (this.runProblems) {
            this.syntaxProblemReporter.run(node, content, requestor);
        }
        if (this.runTasks) {
            this.taskReporter.run(sourceUnit, node, content, requestor);
        }
    }

    private void runReporters(RSourceUnit sourceUnit, @Nullable AstNode node, @Nullable RSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        if (node == null) {
            return;
        }
        if (node instanceof RAstNode) {
            this.runReporters(sourceUnit, (RAstNode)node, modelInfo, content, requestor, level);
        } else {
            int n = node.getChildCount();
            int i = 0;
            while (i < n) {
                AstNode child = node.getChild(i);
                if (child instanceof RAstNode) {
                    this.runReporters(sourceUnit, (RAstNode)child, modelInfo, content, requestor, level);
                }
                ++i;
            }
        }
    }
}

