/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;

@NonNullByDefault
abstract class ExpressionList
extends RAstNode {
    final List<Expression> expressions = new ArrayList<Expression>();

    ExpressionList() {
    }

    @Override
    public final boolean hasChildren() {
        return this.expressions.size() > 0;
    }

    @Override
    public final int getChildIndex(AstNode child) {
        int i = this.expressions.size() - 1;
        while (i >= 0) {
            if (this.expressions.get((int)i).node == child) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public final int getChildCount() {
        return this.expressions.size();
    }

    @Override
    public final RAstNode getChild(int i) {
        return this.expressions.get((int)i).node;
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        for (Expression expr : this.expressions) {
            expr.node.acceptInR(visitor);
        }
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        for (Expression expr : this.expressions) {
            visitor.visit((AstNode)expr.node);
        }
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        int i = this.expressions.size() - 1;
        while (i >= 0) {
            if (this.expressions.get((int)i).node == child) {
                return this.expressions.get(i);
            }
            --i;
        }
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    Expression appendNewExpr() {
        Expression expr = new Expression();
        this.expressions.add(expr);
        return expr;
    }

    void setSeparator(int offset) {
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        return 768;
    }
}

