/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.debug.core.RDebugTarget;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpoint;

@NonNullByDefault
public abstract class BasicRBreakpoint
extends Breakpoint
implements RBreakpoint {
    public static final String INSTALL_COUNT_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.InstallCountAttribute";
    private final Map<RDebugTarget, RBreakpoint.ITargetData> installedTargets = new ConcurrentHashMap<RDebugTarget, RBreakpoint.ITargetData>();
    private final AtomicInteger installCount = new AtomicInteger();

    protected BasicRBreakpoint() {
        this.updateInstallCount(this.installCount.get());
    }

    public String getModelIdentifier() {
        return "org.eclipse.statet.r.debugModels.R";
    }

    protected void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    protected void update() {
    }

    @Override
    public @Nullable RBreakpoint.ITargetData registerTarget(RDebugTarget target, RBreakpoint.ITargetData data) {
        ObjectUtils.nonNullAssert((Object)target);
        RBreakpoint.ITargetData oldData = this.installedTargets.put(target, data);
        if (oldData != null && oldData.isInstalled()) {
            if (data == null || !data.isInstalled()) {
                this.updateInstallCount(this.installCount.decrementAndGet());
            }
        } else if (data != null && data.isInstalled()) {
            this.updateInstallCount(this.installCount.incrementAndGet());
        }
        return oldData;
    }

    @Override
    public @Nullable RBreakpoint.ITargetData unregisterTarget(RDebugTarget target) {
        ObjectUtils.nonNullAssert((Object)target);
        RBreakpoint.ITargetData oldData = this.installedTargets.remove(target);
        if (oldData != null && oldData.isInstalled()) {
            this.updateInstallCount(this.installCount.decrementAndGet());
        }
        return oldData;
    }

    private void updateInstallCount(int count) {
        try {
            this.ensureMarker().setAttribute(INSTALL_COUNT_MARKER_ATTR, count);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    public @Nullable RBreakpoint.ITargetData getTargetData(RDebugTarget target) {
        return this.installedTargets.get(target);
    }

    @Override
    public boolean isInstalled() throws CoreException {
        return this.installCount.get() > 0;
    }
}

