/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.actions;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.statet.internal.r.debug.ui.RDebugUIUtils;
import org.eclipse.statet.internal.r.debug.ui.actions.StepIntoSelectionHandler;
import org.eclipse.statet.internal.r.debug.ui.actions.StepIntoSelectionHyperlink;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.nico.AbstractRDbgController;

@NonNullByDefault
public class StepIntoSelectionHyperlinkDetector
extends AbstractHyperlinkDetector {
    public @NonNull IHyperlink @Nullable [] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        SourceEditor editor = (SourceEditor)this.getAdapter(SourceEditor.class);
        if (editor == null) {
            return null;
        }
        AbstractRDbgController controller = RDebugUIUtils.getRDbgController(editor);
        if (controller == null || controller.getStatus() != ToolStatus.STARTED_SUSPENDED) {
            return null;
        }
        RElementAccess access = StepIntoSelectionHandler.searchAccess(editor, region);
        if (access != null) {
            return new IHyperlink[]{new StepIntoSelectionHyperlink(editor, access, controller)};
        }
        return null;
    }
}

