/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.internal.r.ui.editors.Messages;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.core.rmodel.RModel;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.ui.sourceediting.ROpenDeclaration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenRElementHyperlink
implements IHyperlink {
    private final SourceEditor editor;
    private final IRegion region;
    private final RSourceUnit su;
    private final RElementAccess access;

    public OpenRElementHyperlink(SourceEditor editor, RSourceUnit su, RElementAccess access) {
        assert (su != null);
        assert (access != null);
        this.editor = editor;
        this.region = JFaceTextRegion.toJFaceRegion((TextRegion)((TextRegion)ObjectUtils.nonNullAssert((Object)access.getNameNode())));
        this.su = su;
        this.access = access;
    }

    public String getTypeLabel() {
        return null;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return NLS.bind((String)Messages.Hyperlinks_OpenDeclaration_label, (Object)this.access.getDisplayName());
    }

    public void open() {
        try {
            List list = RModel.searchDeclaration((RElementAccess)this.access, (RSourceUnit)this.su);
            ROpenDeclaration open = new ROpenDeclaration();
            SourceElement element = (SourceElement)open.selectElement(list, this.editor.getWorkbenchPart());
            if (element != null) {
                open.open(element, true);
            } else {
                Display.getCurrent().beep();
            }
        }
        catch (PartInitException e) {
            Display.getCurrent().beep();
            StatusManager.getManager().handle((IStatus)new Status(1, "org.eclipse.statet.ecommons.uimisc", -1, NLS.bind((String)"An error occurred when following the hyperlink and opening the editor for the declaration of ''{0}''", (Object)this.access.getDisplayName()), (Throwable)e));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

