/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.refactoring;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.refactoring.Messages;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringBasedStatus;
import org.eclipse.statet.r.core.refactoring.ExtractTempRefactoring;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExtractTempWizard
extends RefactoringWizard {
    public ExtractTempWizard(ExtractTempRefactoring ref) {
        super((Refactoring)ref, 100);
        this.setDefaultPageTitle(Messages.ExtractTemp_Wizard_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new InputPage());
    }

    private static class InputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ExtractTemp.InputPage";
        private Text variableNameControl;
        private Button replaceAllControl;

        public InputPage() {
            super(PAGE_NAME);
        }

        protected ExtractTempRefactoring getRefactoring() {
            return (ExtractTempRefactoring)super.getRefactoring();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
            this.setControl((Control)composite);
            int count = this.getRefactoring().getAllOccurrencesCount();
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            label.setText(Messages.ExtractTemp_Wizard_header);
            label.setFont(JFaceResources.getBannerFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            label.setText(Messages.ExtractTemp_Wizard_VariableName_label);
            this.variableNameControl = new Text(composite, 2048);
            this.variableNameControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.variableNameControl.setFont(JFaceResources.getTextFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            if (count > 0) {
                label = new Label(composite, 64);
                label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                if (count == 1) {
                    label.setText("No other occurrences of the selected expression found.");
                } else {
                    label.setText(NLS.bind((String)"{0} other occurrences of the selected expression found.", (Object)(count - 1)));
                }
            }
            this.replaceAllControl = new Button(composite, 32);
            this.replaceAllControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.replaceAllControl.setText(Messages.ExtractTemp_Wizard_ReplaceAll_label);
            if (count <= 1) {
                this.replaceAllControl.setEnabled(false);
            }
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Dialog.applyDialogFont((Control)composite);
            this.initBindings();
        }

        protected void initBindings() {
            Realm realm = Realm.getDefault();
            DataBindingContext dbc = new DataBindingContext(realm);
            this.addBindings(dbc, realm);
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        }

        protected void addBindings(DataBindingContext dbc, Realm realm) {
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.variableNameControl), PojoProperties.value(ExtractTempRefactoring.class, (String)"tempName", String.class).observe(realm, (Object)this.getRefactoring()), new UpdateValueStrategy().setAfterGetValidator(value -> new RefactoringBasedStatus(this.getRefactoring().checkTempName(value))), null);
            dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.replaceAllControl), PojoProperties.value(ExtractTempRefactoring.class, (String)"replaceAllOccurrences", Boolean.TYPE).observe(realm, (Object)this.getRefactoring()));
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.variableNameControl.setFocus();
        }
    }
}

