/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.search;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResult;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResultPage;
import org.eclipse.statet.ecommons.workbench.search.ui.LineElement;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultTreeContentProvider;
import org.eclipse.statet.internal.r.ui.search.RElementMatch;
import org.eclipse.statet.internal.r.ui.search.RElementSearchResultPage;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.collections.SortedListSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class RElementSearchResultTreeContentProvider
extends TextSearchResultTreeContentProvider<RSourceUnit, RElementMatch> {
    protected static final int BY_PROJECT = 1;
    protected static final int BY_SOURCE_UNIT = 5;
    private int level = 1;
    private final Map<Object, SortedListSet<Object>> levelChildren = new HashMap<Object, SortedListSet<Object>>();

    public RElementSearchResultTreeContentProvider(RElementSearchResultPage page, TreeViewer viewer) {
        super((ExtTextSearchResultPage)page, viewer);
    }

    protected void reset() {
        super.reset();
        this.levelChildren.clear();
    }

    public void setLevel(int level) {
        this.level = level;
        this.clear();
    }

    protected int getElementLimit() {
        if (this.level < 5) {
            return Integer.MAX_VALUE;
        }
        return super.getElementLimit();
    }

    public Object[] getElements(Object inputElement) {
        if (this.level < 5) {
            SortedListSet<Object> children;
            if (!this.active) {
                ExtTextSearchResult result = this.getInput();
                assert (inputElement == result);
                if (result == null) {
                    return NO_ELEMENTS;
                }
                assert (this.levelChildren.isEmpty());
                RSourceUnit[] elements = (RSourceUnit[])result.getElements();
                int i = 0;
                while (i < elements.length) {
                    this.doAdd(null, elements[i]);
                    ++i;
                }
                this.active = true;
            }
            return (children = this.levelChildren.get(null)) != null ? children.toArray() : NO_ELEMENTS;
        }
        return super.getElements(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof SourceUnit && this.level < 5) {
            IFile file = (IFile)((SourceUnit)element).getResource();
            return file.getParent();
        }
        if (element instanceof IResource) {
            if (element instanceof IProject) {
                return null;
            }
            return ((IResource)element).getParent();
        }
        if (element instanceof LineElement) {
            return ((LineElement)element).getElement();
        }
        return super.getParent(element);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IResource) {
            SortedListSet<Object> children = this.levelChildren.get(parentElement);
            return children != null ? children.toArray() : NO_ELEMENTS;
        }
        return super.getChildren(parentElement);
    }

    public Object[] getShownMatches(RElementMatch[] matches) {
        ArrayList<LineElement<RSourceUnit>> groups = new ArrayList<LineElement<RSourceUnit>>();
        LineElement<RSourceUnit> lastGroup = null;
        int i = 0;
        while (i < matches.length) {
            LineElement<RSourceUnit> group = matches[i].getMatchGroup();
            if (group != lastGroup) {
                groups.add(group);
                lastGroup = group;
            }
            ++i;
        }
        return groups.toArray();
    }

    protected void addElement(TreeViewer viewer, RSourceUnit element, int idx) {
        if (this.level < 5) {
            this.doAdd(viewer, element);
        } else {
            super.addElement(viewer, (Object)element, idx);
        }
    }

    protected void doAdd(TreeViewer viewer, Object element) {
        int idx;
        Object parent = this.getParent(element);
        SortedArraySet children = this.levelChildren.get(parent);
        if (children == null) {
            if (parent != null) {
                this.doAdd(viewer, parent);
            }
            children = new SortedArraySet(NO_ELEMENTS, (Comparator)new LevelComparator());
            this.levelChildren.put(parent, (SortedListSet<Object>)children);
        }
        if ((idx = children.addE(element)) >= 0 && viewer != null) {
            viewer.insert(parent != null ? parent : TreePath.EMPTY, element, idx);
        }
    }

    protected void removeElement(TreeViewer viewer, RSourceUnit element, int idx) {
        if (this.level < 5) {
            this.doRemove(viewer, element);
        } else {
            super.removeElement(viewer, (Object)element, idx);
        }
    }

    protected void doRemove(TreeViewer viewer, Object element) {
        Object parent = this.getParent(element);
        SortedListSet<Object> children = this.levelChildren.get(parent);
        if (children == null) {
            return;
        }
        if (children.removeE(element) >= 0) {
            if (children.isEmpty() && parent != null) {
                this.doRemove(viewer, parent);
            } else if (viewer != null) {
                viewer.remove(element);
            }
        }
    }

    private static class LevelComparator
    extends ResourceComparator
    implements Comparator<Object> {
        public LevelComparator() {
            super(1);
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof SourceUnit) {
                o1 = ((SourceUnit)o1).getResource();
            }
            if (o2 instanceof SourceUnit) {
                o2 = ((SourceUnit)o2).getResource();
            }
            return this.compare(null, o1, o2);
        }
    }
}

