/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.RHelpKeywordGroupImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpKeywordImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpManagerIntern;
import org.eclipse.statet.internal.rhelp.core.RHelpPageImpl;
import org.eclipse.statet.internal.rhelp.core.RPkgHelpImpl;
import org.eclipse.statet.internal.rhelp.core.SerUtil;
import org.eclipse.statet.internal.rhelp.core.index.AbortIndexOperationException;
import org.eclipse.statet.internal.rhelp.core.index.FlagField;
import org.eclipse.statet.internal.rhelp.core.index.KeywordField;
import org.eclipse.statet.internal.rhelp.core.index.MultiValueFieldList;
import org.eclipse.statet.internal.rhelp.core.index.NameField;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexSchema;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexUtils;
import org.eclipse.statet.internal.rhelp.core.index.RHelpHtmlUtils;
import org.eclipse.statet.internal.rhelp.core.index.TxtField;
import org.eclipse.statet.internal.rhelp.core.index.WriteAnalyzer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.io.FileUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.CancelStatus;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.jcommons.text.core.util.HtmlStripParserInput;
import org.eclipse.statet.rhelp.core.DocResource;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpKeywordGroup;
import org.eclipse.statet.rhelp.core.RHelpKeywordNode;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkgDescription;

@NonNullByDefault
public class REnvIndexWriter
implements REnvIndexSchema {
    public static final Collection<String> IGNORE_PKG_NAMES = new ArrayList<String>();
    private static Analyzer WRITE_ANALYZER;
    private final RHelpManagerIntern rHelpManager;
    private final REnvHelpConfiguration rEnvConfig;
    private long stamp;
    private @Nullable String docDir;
    private @Nullable Path docDirPath;
    private final List<DocResource> manuals = new ArrayList<DocResource>();
    private final List<DocResource> miscRes = new ArrayList<DocResource>();
    private Map<String, RPkgHelp> existingPackages;
    private Map<String, @Nullable RPkgHelp> packages;
    private LinkedHashMap<String, RHelpKeywordGroupImpl> keywordGroups;
    private final Path indexDirectory;
    private FSDirectory luceneDirectory;
    private IndexWriter luceneWriter;
    private @Nullable RPkgHelpImpl currentPkg;
    private final List<RHelpPageImpl> currentPkgPages = new ArrayList<RHelpPageImpl>(1024);
    private @Nullable Object indexLock;
    private @Nullable Map<String, String> rEnvSharedProperties;
    private boolean reset;
    private final PackageWorker worker = new PackageWorker();
    private @Nullable MultiStatus status;

    static {
        IGNORE_PKG_NAMES.add("translations");
        String s = System.getProperty("org.eclipse.statet.rhelp.PkgsToExclude.names");
        if (s == null) {
            s = System.getProperty("org.eclipse.statet.r.rhelp.PkgsToExclude.names");
        }
        if (s != null && !(s = s.trim()).isEmpty()) {
            String[] stringArray = s.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!name.isEmpty() && !IGNORE_PKG_NAMES.contains(name)) {
                    IGNORE_PKG_NAMES.add(name);
                }
                ++n2;
            }
        }
        WRITE_ANALYZER = new WriteAnalyzer();
    }

    public REnvIndexWriter(REnvHelpConfiguration rEnvConfig, RHelpManagerIntern rHelpManager) {
        this.rEnvConfig = rEnvConfig;
        this.rHelpManager = rHelpManager;
        this.indexDirectory = SerUtil.getIndexDirectoryChecked(rEnvConfig);
    }

    public void log(Status status) {
        MultiStatus multiStatus = this.status;
        if (multiStatus != null) {
            multiStatus.add(status);
        } else {
            RHelpCoreInternals.log(status);
        }
    }

    public void beginBatch(boolean reset) throws AbortIndexOperationException, StatusException {
        if (this.luceneWriter != null) {
            throw new IllegalStateException();
        }
        this.status = new MultiStatus("org.eclipse.statet.rhelp.core", String.format("Indexing: '%1$s'.", this.rEnvConfig.getName()));
        try {
            block27: {
                this.indexLock = this.rHelpManager.beginIndexUpdate(this.rEnvConfig.getREnv());
                if (this.indexLock == null) {
                    CancelStatus status = new CancelStatus("org.eclipse.statet.rhelp.core", "Indexing is already running in another task.");
                    this.status.add((Status)status);
                    throw new StatusException((Status)status);
                }
                this.status.add((Status)new InfoStatus("org.eclipse.statet.rhelp.core", String.format("Beginning batch (index directory= '%1$s').", this.indexDirectory.toString())));
                this.luceneDirectory = REnvIndexUtils.getDirectory(this.indexDirectory);
                this.reset = true;
                if (!reset) {
                    REnvHelpImpl oldHelp = this.rHelpManager.getHelpIntern(this.rEnvConfig.getREnv());
                    try {
                        if (oldHelp == null || oldHelp.getVersion() != 12) break block27;
                        try {
                            Throwable throwable = null;
                            Object var4_9 = null;
                            try (DirectoryReader dirReader = DirectoryReader.open((Directory)this.luceneDirectory);){
                                this.existingPackages = new HashMap<String, RPkgHelp>(64);
                                for (LeafReaderContext leave : dirReader.leaves()) {
                                    BytesRef term;
                                    LeafReader aReader = leave.reader();
                                    Terms terms = aReader.terms("pkg");
                                    if (terms == null) continue;
                                    TermsEnum termsEnum = terms.iterator();
                                    while ((term = termsEnum.next()) != null) {
                                        String name = term.utf8ToString();
                                        RPkgHelp pkgHelp = oldHelp != null ? oldHelp.getPkgHelp(name) : null;
                                        this.existingPackages.put(name, pkgHelp);
                                    }
                                }
                                IndexWriterConfig config = this.createWriterConfig();
                                config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                                this.luceneWriter = new IndexWriter((Directory)this.luceneDirectory, config);
                                this.reset = false;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            assert (this.luceneWriter == null);
                        }
                    }
                    finally {
                        if (oldHelp != null) {
                            oldHelp.unlock();
                        }
                    }
                }
            }
            if (this.luceneWriter == null) {
                this.existingPackages = new HashMap<String, RPkgHelp>(0);
                try {
                    IndexWriterConfig config = this.createWriterConfig();
                    config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                    this.luceneWriter = new IndexWriter((Directory)this.luceneDirectory, config);
                }
                catch (IndexFormatTooOldException e) {
                    if (Files.exists(this.indexDirectory, new LinkOption[0])) {
                        FileUtils.cleanDirectory((Path)this.indexDirectory);
                        IndexWriterConfig config = this.createWriterConfig();
                        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                        this.luceneWriter = new IndexWriter((Directory)this.luceneDirectory, config);
                    }
                    throw e;
                }
            }
            this.stamp = REnvHelpImpl.createStamp();
            this.packages = new LinkedHashMap<String, RPkgHelp>();
            this.keywordGroups = new LinkedHashMap();
        }
        catch (IOException | OutOfMemoryError e) {
            throw new AbortIndexOperationException(e);
        }
    }

    private IndexWriterConfig createWriterConfig() {
        IndexWriterConfig config = new IndexWriterConfig(WRITE_ANALYZER);
        config.setSimilarity(SIMILARITY);
        config.setRAMPerThreadHardLimitMB(512);
        config.setCommitOnClose(false);
        return config;
    }

    public @Nullable String getDocDir() {
        return this.docDir;
    }

    public void setDocDir(@Nullable String docDir, @Nullable Path docDirPath, @Nullable Exception cause) {
        if (docDir != null && docDir.isEmpty()) {
            docDir = null;
        }
        StringBuilder message = new StringBuilder("Setting doc dir to: ");
        if (docDir != null) {
            message.append('\'').append(docDir).append('\'');
            if (docDirPath == null) {
                message.append(" (not resolved)");
            }
        } else {
            message.append("<missing>");
        }
        this.status.add(Status.newStatus((int)(docDirPath != null ? 1 : 2), (String)"org.eclipse.statet.rhelp.core", (String)message.toString(), (Throwable)cause));
        this.docDir = docDir;
        this.docDirPath = docDirPath;
    }

    public void addManual(DocResource res) {
        this.manuals.add(res);
    }

    public void addManuals(Collection<DocResource> resources) {
        this.manuals.addAll(resources);
    }

    public void addMiscResource(DocResource res) {
        this.miscRes.add(res);
    }

    public void addMiscResources(Collection<DocResource> resources) {
        this.miscRes.addAll(resources);
    }

    public void setREnvSharedProperties(@Nullable Map<String, String> properties) {
        this.rEnvSharedProperties = properties;
    }

    public void addDefaultKeyword(String[] path, String description) {
        if (path == null || path.length == 0) {
            return;
        }
        if (path.length == 1) {
            String key = path[0].trim().intern();
            if (key.length() > 0) {
                this.keywordGroups.put(key, new RHelpKeywordGroupImpl(key, description));
            }
            return;
        }
        RHelpKeywordNode node = this.keywordGroups.get(path[0]);
        int i = 1;
        while (node != null) {
            if (i == path.length - 1) {
                if (path[i].length() <= 0) continue;
                String key = path[i].intern();
                node.getNestedKeywords().add(new RHelpKeywordImpl(key, description));
                return;
            }
            node = node.getNestedKeyword(path[i++]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPackage(String name, RNumVersion version, String built, RLibLocation libLocation) {
        if (IGNORE_PKG_NAMES.contains(name)) {
            return true;
        }
        Map<String, RPkgHelp> map = this.packages;
        synchronized (map) {
            block8: {
                block7: {
                    if (!this.packages.containsKey(name)) break block7;
                    return true;
                }
                RPkgHelp pkgHelp = this.existingPackages.remove(name);
                if (this.reset || pkgHelp == null || !version.equals((Object)pkgHelp.getVersion()) || !built.equals(pkgHelp.getPkgDescription().getBuilt())) break block8;
                if (libLocation != pkgHelp.getPkgDescription().getLibLocation()) {
                    pkgHelp = new RPkgHelpImpl(pkgHelp, libLocation);
                }
                this.packages.put(name, pkgHelp);
                return true;
            }
            this.packages.put(name, null);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginPackage(RPkgDescription pkgDesription) throws AbortIndexOperationException {
        String name = pkgDesription.getName();
        if (this.currentPkg != null) {
            throw new IllegalArgumentException();
        }
        try {
            this.status.add((Status)new InfoStatus("org.eclipse.statet.rhelp.core", String.format("Beginning package: '%1$s'.", name)));
            this.currentPkg = new RPkgHelpImpl(pkgDesription, this.rEnvConfig.getREnv());
            Map<String, RPkgHelp> map = this.packages;
            synchronized (map) {
                this.existingPackages.remove(name);
                this.packages.put(name, this.currentPkg);
            }
            this.currentPkgPages.clear();
            this.luceneWriter.deleteDocuments(new Term[]{new Term("pkg", name)});
            this.worker.addToLucene(pkgDesription);
        }
        catch (IOException | OutOfMemoryError e) {
            throw new AbortIndexOperationException(e);
        }
    }

    public void add(RdItem item) throws AbortIndexOperationException {
        RPkgHelpImpl currentPkg = this.currentPkg;
        if (currentPkg == null || !currentPkg.getName().equals(item.getPkg())) {
            throw new IllegalArgumentException();
        }
        try {
            item.finish();
            this.currentPkgPages.add(new RHelpPageImpl(currentPkg, item.getName(), RHelpPageImpl.createFlags(item.isInternal()), item.getTopics(), item.getTitle()));
            this.worker.addToLucene(item);
        }
        catch (IOException | OutOfMemoryError e) {
            throw new AbortIndexOperationException(e);
        }
    }

    public void endPackage() throws AbortIndexOperationException {
        if (RHelpCoreInternals.DEBUG) {
            this.status.add((Status)new InfoStatus("org.eclipse.statet.rhelp.core", "Finishing package."));
            Runtime runtime = Runtime.getRuntime();
            long maxMemory = runtime.maxMemory();
            long allocatedMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            LiveIndexWriterConfig config = this.luceneWriter.getConfig();
            StringBuilder sb = new StringBuilder("Memory status:\n");
            sb.append("TempBuilder-capycity: ").append(this.worker.tempBuilder.capacity()).append('\n');
            sb.append("Lucene-buffersize: ").append((long)(config.getRAMBufferSizeMB() * 1024.0)).append('\n');
            sb.append("Memory-free: ").append(freeMemory / 1024L).append('\n');
            sb.append("Memory-total: ").append(allocatedMemory / 1024L).append('\n');
            sb.append("Memory-max: ").append(maxMemory / 1024L).append('\n');
            this.status.add((Status)new InfoStatus("org.eclipse.statet.rhelp.core", sb.toString()));
        }
        if (this.currentPkg == null) {
            return;
        }
        this.currentPkg.setPages((ImList<RHelpPage>)ImCollections.toList(this.currentPkgPages));
        this.currentPkg = null;
    }

    public @Nullable Status endBatch() throws AbortIndexOperationException {
        if (this.luceneWriter == null) {
            return null;
        }
        MultiStatus status = this.status;
        this.status = null;
        if (status != null) {
            status.add((Status)new InfoStatus("org.eclipse.statet.rhelp.core", "Finishing batch."));
            RHelpCoreInternals.log((Status)status);
        }
        try {
            for (String pkgName : this.existingPackages.keySet()) {
                this.luceneWriter.deleteDocuments(new Term[]{new Term("pkg", pkgName)});
            }
            this.existingPackages.clear();
            ImList<DocResource> manuals = this.checkDocResources(this.manuals, this.docDirPath);
            ImList<DocResource> miscRes = this.checkDocResources(this.miscRes, this.docDirPath);
            Collection<RHelpKeywordGroupImpl> values = this.keywordGroups.values();
            for (RHelpKeywordGroupImpl group : values) {
                group.freeze();
            }
            ImList keywords = ImCollections.toList(values);
            Iterator<RPkgHelp> iter = this.packages.values().iterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
            }
            Object[] array = this.packages.values().toArray(new RPkgHelp[this.packages.size()]);
            Arrays.sort(array);
            ImList packages = ImCollections.newList((Object[])array);
            REnvHelpImpl help = new REnvHelpImpl(this.rEnvConfig.getREnv(), 12, this.stamp, this.docDir, manuals, miscRes, (ImList<RHelpKeywordGroup>)keywords, (ImList<RPkgHelp>)packages);
            this.luceneWriter.commit();
            this.rHelpManager.updateLocalHelp(this.rEnvConfig, this.rEnvSharedProperties, help);
            this.luceneWriter.close();
            this.luceneWriter = null;
            if (status != null && status.getSeverity() >= 2) {
                MultiStatus multiStatus = status;
                return multiStatus;
            }
            return null;
        }
        catch (IOException e) {
            this.cancel();
            throw new AbortIndexOperationException(e);
        }
        catch (OutOfMemoryError e) {
            throw new AbortIndexOperationException(e);
        }
        finally {
            this.clear();
        }
    }

    public @Nullable Status cancel() {
        MultiStatus status;
        block12: {
            block10: {
                try {
                    try {
                        block11: {
                            if (this.luceneWriter == null) break block10;
                            try {
                                this.luceneWriter.rollback();
                            }
                            catch (Exception e) {
                                if (this.status == null) break block11;
                                this.status.add((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "Error when rolling back.", null));
                            }
                        }
                        this.luceneWriter.close();
                        this.luceneWriter = null;
                    }
                    catch (Exception exception) {
                        this.clear();
                        status = this.status;
                        this.status = null;
                        if (status != null) {
                            status.add((Status)new InfoStatus("org.eclipse.statet.rhelp.core", "Canceling batch."));
                            RHelpCoreInternals.log((Status)status);
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.clear();
                    MultiStatus status2 = this.status;
                    this.status = null;
                    if (status2 != null) {
                        status2.add((Status)new InfoStatus("org.eclipse.statet.rhelp.core", "Canceling batch."));
                        RHelpCoreInternals.log((Status)status2);
                    }
                    throw throwable;
                }
            }
            this.clear();
            status = this.status;
            this.status = null;
            if (status != null) {
                status.add((Status)new InfoStatus("org.eclipse.statet.rhelp.core", "Canceling batch."));
                RHelpCoreInternals.log((Status)status);
            }
        }
        if (status != null && status.getSeverity() >= 2) {
            return status;
        }
        return null;
    }

    private void clear() {
        if (this.luceneWriter != null) {
            try {
                if (this.luceneWriter.isOpen()) {
                    this.luceneWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.luceneWriter = null;
        if (this.indexLock != null) {
            this.rHelpManager.endIndexUpdate(this.indexLock);
            this.indexLock = null;
        }
        this.luceneDirectory = null;
        this.currentPkg = null;
        this.currentPkgPages.clear();
        this.indexLock = null;
    }

    private ImList<DocResource> checkDocResources(List<DocResource> resources, @Nullable Path basePath) {
        if (basePath == null) {
            return ImCollections.emptyList();
        }
        ListIterator<DocResource> iter = resources.listIterator();
        while (iter.hasNext()) {
            DocResource res = iter.next();
            if (Files.isRegularFile(basePath.resolve(res.getPath()), new LinkOption[0])) {
                if (res.getPdfPath() == null || Files.isRegularFile(basePath.resolve(res.getPdfPath()), new LinkOption[0])) continue;
                iter.set(new DocResource(res.getTitle(), res.getPath(), null));
                continue;
            }
            iter.remove();
        }
        return ImCollections.toList(resources);
    }

    class PackageWorker {
        private final FlagField doctypeField_PKG_DESCRIPTION = new FlagField("doctype", "RPkgDescription");
        private final FlagField doctypeField_PAGE = new FlagField("doctype", "RHelpPage");
        private final NameField packageField = new NameField("pkg");
        private final NameField pageField = new NameField("page");
        private final TxtField titleTxtField = new TxtField("title.txt");
        private final MultiValueFieldList<NameField> aliasFields = MultiValueFieldList.forNameField("alias");
        private final MultiValueFieldList<TxtField> aliasTxtFields = MultiValueFieldList.forTxtField("alias.txt");
        private final TxtField descriptionTxtField = new TxtField("descr.txt");
        private final TxtField authorsTxtField = new TxtField("authors.txt");
        private final TxtField maintainerTxtField = new TxtField("maintainer.txt");
        private final MultiValueFieldList<TxtField> urlTxtFields = MultiValueFieldList.forTxtField("url.txt");
        private final MultiValueFieldList<KeywordField> keywordTxtFields = MultiValueFieldList.forKeywordField("keyword");
        private final MultiValueFieldList<TxtField> conteptTxtFields = MultiValueFieldList.forTxtField("concept.txt");
        private final TxtField docTxtField = new TxtField("doc.txt");
        private final TxtField.OmitNorm docHtmlField = new TxtField.OmitNorm("doc.html");
        private final TxtField examplesTxtField = new TxtField("examples.txt");
        private final StringBuilder tempBuilder = new StringBuilder(65536);
        private final HtmlStripParserInput tempHtmlInput = new HtmlStripParserInput((TextParserInput)new StringParserInput(2048), 2048);

        private void addToLucene(RPkgDescription item) throws CorruptIndexException, IOException {
            Document doc = new Document();
            doc.add((IndexableField)this.doctypeField_PKG_DESCRIPTION);
            this.packageField.setStringValue(item.getName());
            doc.add((IndexableField)this.packageField);
            this.descriptionTxtField.setStringValue(item.getDescription());
            doc.add((IndexableField)this.descriptionTxtField);
            if (item.getAuthor() != null) {
                this.authorsTxtField.setStringValue(item.getAuthor());
                doc.add((IndexableField)this.authorsTxtField);
            }
            if (item.getMaintainer() != null) {
                this.maintainerTxtField.setStringValue(item.getMaintainer());
                doc.add((IndexableField)this.maintainerTxtField);
            }
            ImList urls = item.getUrls();
            int i = 0;
            while (i < urls.size()) {
                TxtField txtField = this.urlTxtFields.get(i);
                txtField.setStringValue((String)urls.get(i));
                doc.add((IndexableField)txtField);
                ++i;
            }
            REnvIndexWriter.this.luceneWriter.addDocument((Iterable)doc);
        }

        private void addToLucene(RdItem item) throws CorruptIndexException, IOException {
            Document doc = new Document();
            doc.add((IndexableField)this.doctypeField_PAGE);
            this.packageField.setStringValue(item.getPkg());
            doc.add((IndexableField)this.packageField);
            this.pageField.setStringValue(item.getName());
            doc.add((IndexableField)this.pageField);
            this.titleTxtField.setStringValue(item.getTitle());
            doc.add((IndexableField)this.titleTxtField);
            ImList<String> topics = item.getTopics();
            int i = 0;
            while (i < topics.size()) {
                NameField nameField = this.aliasFields.get(i);
                nameField.setStringValue((String)topics.get(i));
                doc.add((IndexableField)nameField);
                TxtField txtField = this.aliasTxtFields.get(i);
                txtField.setStringValue((String)topics.get(i));
                doc.add((IndexableField)txtField);
                ++i;
            }
            if (item.keywords != null) {
                List<String> keywords = item.keywords;
                i = 0;
                while (i < keywords.size()) {
                    KeywordField field = this.keywordTxtFields.get(i);
                    field.setStringValue(keywords.get(i));
                    doc.add((IndexableField)field);
                    ++i;
                }
            }
            if (item.concepts != null) {
                List<String> concepts = item.concepts;
                i = 0;
                while (i < concepts.size()) {
                    TxtField txtField = this.conteptTxtFields.get(i);
                    txtField.setStringValue(concepts.get(i));
                    doc.add((IndexableField)txtField);
                    ++i;
                }
            }
            if (item.html != null) {
                this.createSectionsTxt(item);
                if (item.descrTxt != null) {
                    this.descriptionTxtField.setStringValue(item.descrTxt);
                    doc.add((IndexableField)this.descriptionTxtField);
                }
                this.docTxtField.setStringValue(item.mainTxt);
                doc.add((IndexableField)this.docTxtField);
                if (item.examplesTxt != null) {
                    this.examplesTxtField.setStringValue(item.examplesTxt);
                    doc.add((IndexableField)this.examplesTxtField);
                }
                this.docHtmlField.setStringValue(item.html);
                doc.add((IndexableField)this.docHtmlField);
            }
            REnvIndexWriter.this.luceneWriter.addDocument((Iterable)doc);
        }

        private void createSectionsTxt(RdItem item) throws IOException {
            int idxEnd;
            int idxBegin;
            String html = item.html;
            this.tempBuilder.setLength(0);
            int idx1 = html.indexOf("</h2>");
            if (idx1 >= 0) {
                html = html.substring(idx1 + 5);
            }
            if ((idx1 = RHelpHtmlUtils.indexOfLastHr(html)) >= 0) {
                html = html.substring(0, idx1);
            }
            if ((idxBegin = html.indexOf("<h3 id=\"description\"")) >= 0 && (idxBegin = html.indexOf(62, idxBegin + 20)) >= 0 && (idxBegin = html.indexOf("</h3>", idxBegin + 1)) >= 0 && (idxEnd = RHelpHtmlUtils.indexOfSectionEnd(html, idxBegin += 5)) >= 0) {
                item.descrTxt = this.html2txt(html.substring(idxBegin, idxEnd));
                html = html.substring(idxEnd);
            }
            String[] stringArray = new String[2];
            stringArray[0] = html;
            String[] s = stringArray;
            if (this.extract(s, "<h3 id=\"examples\"")) {
                item.examplesTxt = this.html2txt(s[1]);
            }
            item.mainTxt = this.html2txt(s[0]);
        }

        private boolean extract(String[] s, String h3) {
            int idxBegin;
            String html = s[0];
            int idx0 = html.indexOf(h3);
            if (idx0 >= 0 && (idxBegin = html.indexOf(62, idx0 + h3.length())) >= 0 && (idxBegin = html.indexOf("</h3>", idxBegin + 1)) >= 0) {
                int idxEnd = RHelpHtmlUtils.indexOfSectionEnd(html, idxBegin += 5);
                if (idxEnd >= 0) {
                    this.tempBuilder.setLength(0);
                    this.tempBuilder.append(html, 0, idx0);
                    this.tempBuilder.append(html, idxEnd, html.length());
                    s[0] = this.tempBuilder.toString();
                    s[1] = html.substring(idxBegin, idxEnd);
                } else {
                    s[0] = html.substring(0, idx0);
                    s[1] = html.substring(idxBegin);
                }
                return true;
            }
            return false;
        }

        private String html2txt(String html) {
            int c;
            this.tempBuilder.setLength(0);
            ((StringParserInput)this.tempHtmlInput.getSource()).reset(html);
            this.tempHtmlInput.init();
            boolean blank = true;
            while ((c = this.tempHtmlInput.get(0)) >= 0) {
                if (c <= 32) {
                    if (!blank) {
                        blank = true;
                        this.tempBuilder.append(' ');
                    }
                } else {
                    if (blank) {
                        blank = false;
                    }
                    this.tempBuilder.append((char)c);
                }
                this.tempHtmlInput.consume(1);
            }
            c = this.tempBuilder.length();
            return c > 0 && this.tempBuilder.charAt(c - 1) == ' ' ? this.tempBuilder.substring(0, c - 1) : this.tempBuilder.toString();
        }
    }

    public static class RdItem {
        private final String pkg;
        private final String name;
        private final List<String> topics = new ArrayList<String>(8);
        private ImList<String> imTopics;
        private String title = "";
        private @Nullable List<String> keywords;
        private @Nullable List<String> concepts;
        private @Nullable String html;
        private @Nullable String descrTxt;
        private @Nullable String mainTxt;
        private @Nullable String examplesTxt;

        public RdItem(String pkg, String name) {
            this.pkg = pkg;
            this.name = name.intern();
        }

        void finish() {
            this.imTopics = ImCollections.toList(this.topics);
        }

        public String getPkg() {
            return this.pkg;
        }

        public String getName() {
            return this.name;
        }

        private ImList<String> getTopics() {
            return this.imTopics;
        }

        public void addTopic(String alias) {
            if (!this.topics.contains(alias)) {
                this.topics.add(alias.intern());
            }
        }

        private String getTitle() {
            return this.title;
        }

        public void setTitle(@Nullable String title) {
            if (title != null) {
                this.title = title;
            }
        }

        public void addKeyword(String keyword) {
            List<String> keywords = this.keywords;
            if (keywords == null) {
                this.keywords = keywords = new ArrayList<String>(8);
            }
            if (!keywords.contains(keyword)) {
                keywords.add(keyword);
            }
        }

        public boolean isInternal() {
            List<String> keywords = this.keywords;
            return keywords != null && keywords.contains("internal");
        }

        public void addConcept(String concept) {
            if (this.concepts == null) {
                this.concepts = new ArrayList<String>(8);
            }
            this.concepts.add(concept);
        }

        public void setHtml(String html) {
            this.html = html;
        }
    }
}

