/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.ExecutorService;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.eclipse.statet.internal.rj.servi.APool2;
import org.eclipse.statet.internal.rj.servi.APool2NodeHandler;
import org.eclipse.statet.internal.rj.servi.APool2NodeObject;
import org.eclipse.statet.internal.rj.servi.Messages;
import org.eclipse.statet.internal.rj.servi.NodeFactory;
import org.eclipse.statet.internal.rj.servi.PoolListener;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.CopyOnWriteList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.servi.node.RServiNode;

@NonNullByDefault
public class APool2NodeObjectFactory
implements PooledObjectFactory<APool2NodeHandler> {
    private APool2 pool = (APool2)((Object)ObjectUtils.nonNullLateInit());
    private final NodeFactory nodeFactory;
    private final CopyOnWriteList<APool2NodeHandler> nodes = new CopyOnWriteList();
    private final CopyOnWriteIdentityListSet<PoolListener> poolListeners;
    private int statMaxTotal;
    private int statMaxAllocated;
    private int maxUsageCount;
    private @Nullable RMIClientSocketFactory sslClientSocketFactory;
    private @Nullable RMIServerSocketFactory sslServerSocketFactory;
    private final ThreadLocal<String> activateArguments = new ThreadLocal();
    private final ExecutorService executor;

    public APool2NodeObjectFactory(NodeFactory factory, CopyOnWriteIdentityListSet<PoolListener> poolListeners, ExecutorService executor) {
        this.nodeFactory = factory;
        this.executor = executor;
        this.poolListeners = poolListeners;
    }

    void setPool(APool2 pool) {
        this.pool = pool;
    }

    public void setMaxUsageCount(int count) {
        this.maxUsageCount = count;
    }

    public int getNumAll() {
        return this.nodes.size();
    }

    public ImList<APool2NodeHandler> getAllObjects() {
        return this.nodes.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject<APool2NodeHandler> makeObject() throws Exception {
        APool2NodeHandler poolObj = new APool2NodeHandler(this.pool);
        CopyOnWriteList<APool2NodeHandler> copyOnWriteList = this.nodes;
        synchronized (copyOnWriteList) {
            this.nodes.add((Object)poolObj);
            int total = this.nodes.size();
            if (total > this.statMaxTotal) {
                this.statMaxTotal = total;
            }
        }
        boolean ok = false;
        try {
            if (!this.pool.isOpen()) {
                throw new IllegalStateException("Pool not open");
            }
            for (PoolListener listener : this.poolListeners) {
                try {
                    listener.initializing(poolObj);
                }
                catch (Exception e) {
                    this.onErrorInListener(listener, e);
                }
            }
            this.nodeFactory.createNode(poolObj);
            RMIClientSocketFactory clientSocketFactory = null;
            RMIServerSocketFactory serverSocketFactory = null;
            if (poolObj.address.isSsl()) {
                APool2NodeObjectFactory e = this;
                synchronized (e) {
                    if (this.sslClientSocketFactory == null) {
                        this.sslClientSocketFactory = new SslRMIClientSocketFactory();
                        this.sslServerSocketFactory = new SslRMIServerSocketFactory(null, null, true);
                    }
                    clientSocketFactory = this.sslClientSocketFactory;
                    serverSocketFactory = this.sslServerSocketFactory;
                }
            }
            poolObj.thisRemote = UnicastRemoteObject.exportObject(poolObj, 0, clientSocketFactory, serverSocketFactory);
            for (PoolListener listener : this.poolListeners.toList()) {
                try {
                    listener.initialized(poolObj);
                }
                catch (Exception e) {
                    this.onErrorInListener(listener, e);
                }
            }
            ok = true;
            PooledObject<APool2NodeHandler> pooledObject = poolObj.getPooledObject();
            return pooledObject;
        }
        finally {
            if (!ok) {
                this.destroyObject(poolObj.getPooledObject());
            }
        }
    }

    public void registerArgs(String client) {
        this.activateArguments.set(client);
    }

    public void clearArgs() {
        this.activateArguments.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateObject(PooledObject<APool2NodeHandler> p) throws Exception {
        String clientHost;
        APool2NodeObjectFactory aPool2NodeObjectFactory = this;
        synchronized (aPool2NodeObjectFactory) {
            int numAllocated = this.pool.getNumActive();
            if (numAllocated > this.statMaxAllocated) {
                this.statMaxAllocated = numAllocated;
            }
        }
        String name = this.activateArguments.get();
        APool2NodeHandler poolObj = (APool2NodeHandler)p.getObject();
        RServiNode node = (RServiNode)ObjectUtils.nonNullAssert((Object)poolObj.node);
        try {
            clientHost = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException e) {
            clientHost = node.getPoolHost();
        }
        poolObj.bindClient(name, clientHost);
    }

    public void passivateObject(PooledObject<APool2NodeHandler> p) throws Exception {
        APool2NodeHandler poolObj = (APool2NodeHandler)p.getObject();
        poolObj.unbindClient();
    }

    public boolean validateObject(PooledObject<APool2NodeHandler> p) {
        APool2NodeHandler poolObj = (APool2NodeHandler)p.getObject();
        if (poolObj.isEvictRequested(0L)) {
            return false;
        }
        int max = this.maxUsageCount;
        if (max > 0 && ((APool2NodeObject)p).getBorrowedCount() >= (long)max) {
            poolObj.stats.shutdownReason = 1;
            return false;
        }
        return true;
    }

    public void destroyObject(PooledObject<APool2NodeHandler> p) throws Exception {
        APool2NodeHandler poolObj = (APool2NodeHandler)p.getObject();
        try {
            if (poolObj.thisRemote != null) {
                try {
                    poolObj.thisRemote = null;
                    UnicastRemoteObject.unexportObject(poolObj, true);
                }
                catch (Throwable e) {
                    Utils.logError(Messages.RmiUnexportNode_error_message, e);
                }
            }
        }
        catch (Throwable throwable) {
            this.executor.submit(new Runnable(poolObj){
                private final /* synthetic */ APool2NodeHandler val$poolObj;
                {
                    this.val$poolObj = aPool2NodeHandler;
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        try {
                            APool2NodeObjectFactory.this.nodeFactory.stopNode(this.val$poolObj);
                        }
                        finally {
                            ** for (listener : APool2NodeObjectFactory.this.poolListeners)
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                listener.disposed(this.val$poolObj);
                            }
                            catch (Exception e) {
                                APool2NodeObjectFactory.this.onErrorInListener(listener, e);
                            }
                            continue;
lbl13:
                            // 1 sources

                        }
                    }
                    finally {
                        APool2NodeObjectFactory.this.nodes.remove((Object)this.val$poolObj);
                    }
                }
            });
            throw throwable;
        }
        this.executor.submit(new /* invalid duplicate definition of identical inner class */);
    }

    public int getStatMaxTotal() {
        return this.statMaxTotal;
    }

    public int getStatMaxAllocated() {
        return this.statMaxAllocated;
    }

    private void onErrorInListener(PoolListener listener, Exception e) {
        CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.servi", String.format("An error occurred in pool listener (%1$s) of '%2$s'.", listener.getClass().getSimpleName(), this.pool.getId()), (Throwable)e));
    }
}

