/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.yaml.core.source.ast.NContainer;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.source.ast.YamlParser;

@NonNullByDefault
public abstract class Collection
extends NContainer {
    private Collection(YamlAstNode parent, int startOffset, int endOffset) {
        this.yamlParent = parent;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    abstract int getNodeCode();

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    public abstract int getOpenIndicatorOffset();

    public abstract int getCloseIndicatorOffset();

    public static abstract class BlockCollection
    extends Collection {
        BlockCollection(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public int getOpenIndicatorOffset() {
            return Integer.MIN_VALUE;
        }

        @Override
        public int getCloseIndicatorOffset() {
            return Integer.MIN_VALUE;
        }
    }

    static final class BlockMap
    extends BlockCollection {
        BlockMap(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.MAP;
        }

        @Override
        public char getOperator() {
            return '?';
        }

        @Override
        int getNodeCode() {
            return 200704;
        }
    }

    static final class BlockSeq
    extends BlockCollection {
        BlockSeq(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.SEQ;
        }

        @Override
        public char getOperator() {
            return '-';
        }

        @Override
        int getNodeCode() {
            return 196608;
        }
    }

    public static abstract class FlowCollection
    extends Collection {
        private ImIntList sepOffsets;
        int closeIndicatorOffset = Integer.MIN_VALUE;

        FlowCollection(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        void add(YamlParser.NContainerBuilder containerBuilder, YamlAstNode child) {
            if (containerBuilder.sepOffsets.size() < containerBuilder.children.size()) {
                containerBuilder.sepOffsets.add(Integer.MIN_VALUE);
                if (this.status == 0) {
                    this.status = 0x400570 | this.getNodeCode();
                }
            }
            super.add(containerBuilder, child);
        }

        @Override
        void finish(int endOffset, YamlParser.NContainerBuilder containerBuilder) {
            int minEnd;
            if (this.status == 0 && this.closeIndicatorOffset == Integer.MIN_VALUE) {
                this.status = 0x400520 | this.getNodeCode();
            }
            super.finish(endOffset, containerBuilder);
            this.sepOffsets = ImCollections.toIntList((IntList)containerBuilder.sepOffsets);
            if (!this.sepOffsets.isEmpty() && this.endOffset < (minEnd = this.sepOffsets.getAt(this.sepOffsets.size() - 1) + 1)) {
                this.endOffset = minEnd;
            }
        }

        @Override
        public int getOpenIndicatorOffset() {
            return this.startOffset;
        }

        public ImIntList getSepOffsets() {
            return this.sepOffsets;
        }

        @Override
        public int getCloseIndicatorOffset() {
            return this.closeIndicatorOffset;
        }
    }

    static final class FlowMap
    extends FlowCollection {
        FlowMap(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.MAP;
        }

        @Override
        public char getOperator() {
            return '{';
        }

        @Override
        int getNodeCode() {
            return 233472;
        }
    }

    static final class FlowSeq
    extends FlowCollection {
        FlowSeq(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.SEQ;
        }

        @Override
        public char getOperator() {
            return '[';
        }

        @Override
        int getNodeCode() {
            return 229376;
        }
    }
}

