/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.impl.AbstractAstNode;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;

@NonNullByDefault
public abstract class YamlAstNode
extends AbstractAstNode
implements AstNode {
    int status;
    @Nullable YamlAstNode yamlParent;
    int startOffset;
    int endOffset;

    YamlAstNode() {
    }

    YamlAstNode(@Nullable YamlAstNode parent, int startOffset, int endOffset) {
        this.yamlParent = parent;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    void finish(int endOffset) {
        if (this.hasErrorInChild()) {
            this.status |= 0x4000000;
        }
    }

    protected boolean hasErrorInChild() {
        return false;
    }

    public abstract NodeType getNodeType();

    public char getOperator() {
        return '\u0000';
    }

    public final int getStatusCode() {
        return this.status;
    }

    public final @Nullable YamlAstNode getYamlParent() {
        return this.yamlParent;
    }

    public @Nullable AstNode getParent() {
        return this.yamlParent;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public final int getLength() {
        return this.endOffset - this.startOffset;
    }

    public abstract YamlAstNode getChild(int var1);

    public abstract void acceptInYaml(YamlAstVisitor var1) throws InvocationTargetException;

    public abstract void acceptInYamlChildren(YamlAstVisitor var1) throws InvocationTargetException;

    static void visit(AstVisitor visitor, @Nullable YamlAstNode node) throws InvocationTargetException {
        if (node != null) {
            visitor.visit((AstNode)node);
        }
    }

    static void acceptInYaml(YamlAstVisitor visitor, @Nullable YamlAstNode node) throws InvocationTargetException {
        if (node != null) {
            node.acceptInYaml(visitor);
        }
    }
}

