/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.Random;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class OS {
    public static boolean isWindows() {
        return OS.getOperatingSystem().indexOf("win") >= 0;
    }

    public static boolean isLinux() {
        return OS.getOperatingSystem().indexOf("linux") >= 0;
    }

    public static boolean isMac() {
        return OS.getOperatingSystem().indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.getOperatingSystem().indexOf("unix") >= 0;
    }

    public static boolean isWayland() {
        try {
            return System.getenv("WAYLAND_DISPLAY") != null;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean isWaylandInvalidImage(ImageData imageData) {
        int height;
        int width;
        int size;
        if (imageData != null && (size = (width = imageData.width) * (height = imageData.height)) > 0) {
            RGB rgbBlack = Display.getDefault().getSystemColor(2).getRGB();
            int samples = (int)Math.round(Math.sqrt(size)) + 1;
            Random randomX = new Random(System.currentTimeMillis());
            Random randomY = new Random(System.currentTimeMillis());
            int i = 0;
            while (i < samples) {
                int y;
                int x = randomX.nextInt(0, width);
                RGB rgb = imageData.palette.getRGB(imageData.getPixel(x, y = randomY.nextInt(0, height)));
                if (!rgbBlack.equals((Object)rgb)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isDarkTheme() {
        if (OS.isMac()) {
            Color background = Display.getDefault().getSystemColor(22);
            RGB rgb = background.getRGB();
            return rgb.red < 128 && rgb.green < 128 && rgb.blue < 128;
        }
        return Display.isSystemDarkTheme();
    }

    private static String getOperatingSystem() {
        return System.getProperty("os.name").toLowerCase();
    }
}

