/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesMapper;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;

public class SeriesLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    public static final int INDEX_ID = 0;
    public static final int INDEX_MAPPING_STATUS = 1;
    public static final int INDEX_VISIBLE = 2;
    public static final int INDEX_VISIBLE_IN_LEGEND = 3;
    public static final int INDEX_COLOR = 4;
    public static final int INDEX_DESCRIPTION = 5;
    private BaseChart baseChart = null;
    public static final String[] TITLES = new String[]{Messages.getString("ID"), Messages.getString("MAPPING_STATUS"), Messages.getString("VISIBLE"), Messages.getString("VISIBLE_IN_LEGEND"), Messages.getString("COLOR"), Messages.getString("DESCRIPTION")};
    public static final int[] BOUNDS = new int[]{24, 30, 30, 30, 30, 200};

    public static Color getColor(ISeriesSettings seriesSettings) {
        Color color = null;
        if (seriesSettings instanceof IBarSeriesSettings) {
            IBarSeriesSettings barSeriesSettings = (IBarSeriesSettings)seriesSettings;
            color = barSeriesSettings.getBarColor();
        } else if (seriesSettings instanceof ILineSeriesSettings) {
            ILineSeriesSettings lineSeriesSettings = (ILineSeriesSettings)seriesSettings;
            color = lineSeriesSettings.getLineColor();
        } else if (seriesSettings instanceof IScatterSeriesSettings) {
            IScatterSeriesSettings scatterSeriesSettings = (IScatterSeriesSettings)seriesSettings;
            color = scatterSeriesSettings.getSymbolColor();
        } else if (seriesSettings instanceof ICircularSeriesSettings) {
            ICircularSeriesSettings circularSeriesSettings = (ICircularSeriesSettings)seriesSettings;
            color = circularSeriesSettings.getSliceColor();
        }
        return color;
    }

    public static void setColor(ISeriesSettings seriesSettings, Color color) {
        if (color != null) {
            if (seriesSettings instanceof IBarSeriesSettings) {
                IBarSeriesSettings barSeriesSettings = (IBarSeriesSettings)seriesSettings;
                barSeriesSettings.setBarColor(color);
            } else if (seriesSettings instanceof ILineSeriesSettings) {
                ILineSeriesSettings lineSeriesSettings = (ILineSeriesSettings)seriesSettings;
                lineSeriesSettings.setLineColor(color);
            } else if (seriesSettings instanceof IScatterSeriesSettings) {
                IScatterSeriesSettings scatterSeriesSettings = (IScatterSeriesSettings)seriesSettings;
                scatterSeriesSettings.setSymbolColor(color);
            } else if (seriesSettings instanceof ICircularSeriesSettings) {
                ICircularSeriesSettings circularSeriesSettings = (ICircularSeriesSettings)seriesSettings;
                circularSeriesSettings.setSliceColor(color);
            }
        }
    }

    public void setBaseChart(BaseChart baseChart) {
        this.baseChart = baseChart;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ISeries) {
            ISeriesSettings seriesSettings;
            ISeries series = (ISeries)element;
            Image seriesMarker = ResourceSupport.getImage("seriesMarker.gif");
            Image checked = ResourceSupport.getImage("checked.svg");
            Image unchecked = ResourceSupport.getImage("unchecked.svg");
            Image mappings = ResourceSupport.getImage("mappings.svg");
            if (columnIndex == 0) {
                return seriesMarker;
            }
            if (columnIndex == 2) {
                return series.isVisible() ? checked : unchecked;
            }
            if (columnIndex == 3) {
                return series.isVisibleInLegend() ? checked : unchecked;
            }
            if (columnIndex == 1 && this.baseChart != null && (seriesSettings = SeriesMapper.get(series, this.baseChart)) != null) {
                return mappings;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            switch (columnIndex) {
                case 0: {
                    text = series.getId();
                    break;
                }
                case 1: {
                    text = "";
                    break;
                }
                case 2: {
                    text = "";
                    break;
                }
                case 3: {
                    text = "";
                    break;
                }
                case 4: {
                    text = "";
                    break;
                }
                case 5: {
                    text = series.getDescription();
                    break;
                }
                default: {
                    text = "";
                }
            }
        }
        return text;
    }
}

