/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.events.AbstractEventListener;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.editor.Editor;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.services.IEvaluationService;

public final class EditorEventListener
extends AbstractEventListener
implements IDisposable,
IPropertyListener {
    protected final Editor editor;
    protected boolean disposed = false;
    protected boolean changePending;
    protected boolean fullRefresh;

    public EditorEventListener(Editor editor) {
        Object node;
        Assert.isNotNull((Object)((Object)editor));
        this.editor = editor;
        Object object = node = editor.getEditorInput() != null ? editor.getEditorInput().getAdapter(Object.class) : null;
        if (node instanceof IPropertiesContainer) {
            EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class, node);
        }
        editor.addPropertyListener(this);
    }

    public void dispose() {
        this.disposed = true;
        EventManager.getInstance().removeEventListener((IEventListener)this);
        this.editor.removePropertyListener(this);
    }

    public void eventFired(EventObject event) {
        Object node;
        if (this.disposed) {
            return;
        }
        if (!(event instanceof ChangeEvent)) {
            return;
        }
        ChangeEvent changeEvent = (ChangeEvent)event;
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/editor/eventListener")) {
            UIPlugin.getTraceHandler().trace("Entered eventFired(...). eventId='" + changeEvent.getEventId() + "'" + ", oldValue='" + changeEvent.getOldValue() + "'" + ", newValue='" + changeEvent.getNewValue() + "'", 0, "trace/editor/eventListener", 1, (Object)this);
        }
        Object source = event.getSource();
        Object object = node = this.editor.getEditorInput() != null ? this.editor.getEditorInput().getAdapter(Object.class) : null;
        if (node == null || !node.equals(source)) {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/editor/eventListener")) {
                UIPlugin.getTraceHandler().trace("Dropping out of eventFired(...). Event source does not match editor input.", 0, "trace/editor/eventListener", 2, (Object)this);
            }
            return;
        }
        boolean bl = this.fullRefresh = this.fullRefresh || !"editor.refreshTab".equals(changeEvent.getEventId());
        if (this.changePending) {
            return;
        }
        this.changePending = true;
        Display display = this.editor.getSite().getShell().getDisplay();
        display.timerExec(200, new Runnable(){

            @Override
            public void run() {
                if (EditorEventListener.this.disposed) {
                    return;
                }
                boolean doFullRefresh = EditorEventListener.this.fullRefresh;
                EditorEventListener.this.editor.updatePageList();
                if (doFullRefresh) {
                    Object page = EditorEventListener.this.editor.getSelectedPage();
                    if (page instanceof IFormPage) {
                        ((IFormPage)page).setActive(((IFormPage)page).isActive());
                    }
                    EditorEventListener.this.editor.updatePartName();
                    IEvaluationService service = (IEvaluationService)EditorEventListener.this.editor.getSite().getService(IEvaluationService.class);
                    if (service != null) {
                        service.requestEvaluation("activeEditorInput");
                    }
                }
                EditorEventListener.this.fullRefresh = false;
                EditorEventListener.this.changePending = false;
            }
        });
    }

    public void propertyChanged(Object source, int propId) {
        IEvaluationService service;
        if (!(source != this.editor || this.changePending && this.fullRefresh || 257 != propId || (service = (IEvaluationService)this.editor.getSite().getService(IEvaluationService.class)) == null)) {
            service.requestEvaluation("activeEditorInput");
        }
    }
}

