/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.TransparentRef;

public class HostCollection {
    public static final int FUNCTION = 1;
    public static final int NORMAL = 0;
    private final HostCollection parent;
    private final HashMap reference = new HashMap();
    private int type;
    HashSet transparent = new HashSet();
    private String name;

    public IReference getReference(String key) {
        IReference reference2 = (IReference)this.reference.get(key);
        if (reference2 == null && this.parent != null) {
            return this.parent.getReference(key);
        }
        return reference2;
    }

    public static String parseCompletionString(String id, boolean dotBeforeBrackets) {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int current = id.length();
        Stack<Number> inBrackStack = new Stack<Number>();
        boolean inStringSingle = false;
        boolean inStringDouble = false;
        int i = id.length();
        while (--i >= 0) {
            char c = id.charAt(i);
            if (c == '\'') {
                if (inStringSingle) {
                    inStringSingle = false;
                    continue;
                }
                if (!inStringDouble) {
                    inStringSingle = true;
                }
            }
            if (c == '\"') {
                if (inStringDouble) {
                    inStringDouble = false;
                    continue;
                }
                if (!inStringSingle) {
                    inStringDouble = true;
                }
            }
            if (inStringSingle || inStringDouble) continue;
            if (c == ']') {
                if (inBrackStack.isEmpty()) {
                    String brackets = "[]";
                    if (dotBeforeBrackets && i > 0 && (i - 2 < 0 || id.charAt(i - 2) != '.')) {
                        brackets = ".[]";
                    }
                    sb.insert(0, String.valueOf(brackets) + id.substring(i + 1, current));
                }
                inBrackStack.push(new Integer(i));
                continue;
            }
            if (c == ')') {
                if (inBrackStack.isEmpty()) {
                    sb.insert(0, id.substring(i + 1, current));
                }
                inBrackStack.push(new Long(i));
                continue;
            }
            if (c == '[' || c == '(') {
                if (inBrackStack.isEmpty()) {
                    if (i + 1 < id.length() && id.charAt(i + 1) == c) {
                        id = String.valueOf(id.substring(0, i)) + id.substring(i + 1);
                        return HostCollection.parseCompletionString(id, dotBeforeBrackets);
                    }
                    return String.valueOf(id.substring(i + 1, current)) + sb.toString();
                }
                Object pop = inBrackStack.pop();
                if (c == '[' && !(pop instanceof Integer)) {
                    inBrackStack.push((Number)pop);
                    continue;
                }
                if (c == '(' && !(pop instanceof Long)) {
                    inBrackStack.push((Number)pop);
                    continue;
                }
                current = i;
                continue;
            }
            if (c == '.' || c == ':' || !inBrackStack.isEmpty() || !Character.isWhitespace(c) && Character.isJavaIdentifierPart(c)) continue;
            start = i + 1;
            break;
        }
        if (start == 0 && current == id.length() && inBrackStack.isEmpty()) {
            return id;
        }
        if (!inBrackStack.isEmpty()) {
            Number last = (Number)inBrackStack.pop();
            id = String.valueOf(id.substring(start, last.intValue())) + id.substring(last.intValue() + 1, id.length());
            return HostCollection.parseCompletionString(id, dotBeforeBrackets);
        }
        sb.insert(0, id.substring(start, current));
        return sb.toString();
    }

    public Set queryElements(String completion, boolean useGlobal) {
        completion = HostCollection.parseCompletionString(completion, false);
        IReference r = this.getReference(completion);
        HashSet<IReference> res = new HashSet<IReference>();
        if (r != null) {
            res.add(r);
            return res;
        }
        int pos = completion.indexOf(46);
        if (pos == -1) {
            return res;
        }
        String rootName = completion.substring(0, pos);
        r = this.getReference(rootName);
        ++pos;
        while (pos != 0) {
            if (r == null) {
                return new HashSet();
            }
            int k = completion.indexOf(46, pos);
            String field = k == -1 ? completion.substring(pos) : completion.substring(pos, k);
            r = r.getChild(field, useGlobal);
            pos = k + 1;
        }
        if (r == null) {
            return res;
        }
        res.add(r);
        return res;
    }

    public HostCollection(HostCollection parent) {
        this.parent = parent;
    }

    public Map getReferences() {
        return this.reference;
    }

    public void write(String key, IReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        this.reference.put(key, ref);
    }

    public void add(String key, IReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.reference.get(key);
        if (object == null) {
            this.reference.put(key, ref);
        } else if (object != ref) {
            if (object instanceof CombinedOrReference) {
                ((CombinedOrReference)object).addReference(ref);
                return;
            }
            if (ref instanceof TransparentRef && ((TransparentRef)ref).evaluateReference == object) {
                this.reference.put(key, ref);
                return;
            }
            if (object instanceof TransparentRef && ((TransparentRef)object).evaluateReference instanceof CombinedOrReference) {
                ((CombinedOrReference)((TransparentRef)object).evaluateReference).addReference(ref);
                return;
            }
            if (ref instanceof CombinedOrReference) {
                ((CombinedOrReference)ref).addReference((IReference)object);
            } else {
                CombinedOrReference cor = new CombinedOrReference();
                cor.addReference(ref);
                cor.addReference((IReference)object);
                ref = cor;
            }
            this.reference.put(key, ref);
        }
    }

    public void oneOf(String key, IReference ref, IReference other) {
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (ref.isChildishReference() || other.isChildishReference()) {
            this.add(key, ref);
            this.add(key, other);
        } else if (ref instanceof CombinedOrReference) {
            CombinedOrReference orReference = (CombinedOrReference)ref;
            orReference.addReference(other);
            this.reference.put(key, ref);
        } else if (other instanceof CombinedOrReference) {
            CombinedOrReference orReference = (CombinedOrReference)other;
            orReference.addReference(ref);
            this.reference.put(key, other);
        } else {
            CombinedOrReference cor = new CombinedOrReference();
            cor.addReference(ref);
            cor.addReference(other);
            this.reference.put(key, cor);
        }
    }

    public HostCollection getParent() {
        return this.parent;
    }

    public void mergeIf(HostCollection cl) {
        Iterator i = cl.reference.keySet().iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (!(next instanceof String)) continue;
            String s = (String)next;
            IReference rm = (IReference)cl.reference.get(s);
            this.add(s, rm);
        }
        cl.pach(this);
    }

    public void mergeElseIf(HostCollection cl, HostCollection cl1) {
        HashSet sm = new HashSet(cl.reference.keySet());
        sm.retainAll(cl1.reference.keySet());
        Iterator i = sm.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            IReference rm = (IReference)cl.reference.get(s);
            IReference rm1 = (IReference)cl1.reference.get(s);
            this.oneOf(s, rm, rm1);
        }
        cl1.pach(this);
        cl.pach(this);
    }

    public void override(HostCollection other) {
        this.reference.putAll(other.reference);
    }

    public void setReference(String objId, IReference root) {
        this.reference.put(objId, root);
    }

    public IReference getReferenceNoParentContext(String rootName) {
        return (IReference)this.reference.get(rootName);
    }

    public IReference queryElement(String key1, boolean useGlobal) {
        Set queryElement = this.queryElements(key1, useGlobal);
        if (queryElement.isEmpty()) {
            return null;
        }
        return (IReference)queryElement.iterator().next();
    }

    public void addTransparent(TransparentRef transparentRef) {
        this.transparent.add(transparentRef);
    }

    private void pach(HostCollection col) {
        Iterator iterator = this.transparent.iterator();
        while (iterator.hasNext()) {
            TransparentRef next = (TransparentRef)iterator.next();
            next.patchRef(col);
        }
    }

    public void recordDelete(String objId) {
        this.reference.remove(objId);
    }

    public void setName(String functionName) {
        this.name = functionName;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void recordFunction(Object function, HostCollection collection) {
        this.reference.put(function, collection);
    }

    public HostCollection getFunction(Object funObject) {
        return (HostCollection)this.reference.get(funObject);
    }
}

