/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;

public class CallExpression
extends Expression {
    private ASTNode expression;
    private List arguments;
    private List commas;
    private int LP = -1;
    private int RP = -1;

    public CallExpression(ASTNode parent) {
        super(parent);
    }

    public ASTNode getExpression() {
        return this.expression;
    }

    public void setExpression(ASTNode expression) {
        this.expression = expression;
    }

    public List getArguments() {
        return this.arguments;
    }

    public void setArguments(List arguments) {
        this.arguments = arguments;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public List getCommas() {
        return this.commas;
    }

    public void setCommas(List commas) {
        this.commas = commas;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.arguments.size() == 0 || this.commas.size() == this.arguments.size() - 1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(((ISourceable)this.expression).toSourceString(indentationString));
        buffer.append('(');
        int i = 0;
        while (i < this.arguments.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            ISourceable item = (ISourceable)this.arguments.get(i);
            buffer.append(item.toSourceString(indentationString));
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean isBlock() {
        return false;
    }
}

