/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class ConstDeclaration
extends Statement {
    private Keyword constKeyword;
    private List consts;
    private List commas;
    private int semic = -1;

    public ConstDeclaration(ASTNode parent) {
        super(parent);
    }

    public List getConsts() {
        return this.consts;
    }

    public void setConsts(List consts) {
        this.consts = consts;
    }

    public Keyword getConstKeyword() {
        return this.constKeyword;
    }

    public void setConstKeyword(Keyword keyword) {
        this.constKeyword = keyword;
    }

    public List getCommas() {
        return this.commas;
    }

    public void setCommas(List commas) {
        this.commas = commas;
    }

    public int getSemicolonPosition() {
        return this.semic;
    }

    public void setSemicolonPosition(int semic) {
        this.semic = semic;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.consts.size() == 0 || this.commas.size() == this.consts.size() - 1 ? 1 : 0) != 0);
        Assert.isTrue((this.semic > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("const");
        buffer.append(" ");
        int i = 0;
        while (i < this.consts.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(((ISourceable)this.consts.get(i)).toSourceString(indentationString));
            ++i;
        }
        buffer.append(";\n");
        return buffer.toString();
    }

    public boolean isBlock() {
        return false;
    }
}

