/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IHotCodeReplaceListener;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.core.model.ISourceOffsetLookup;
import org.eclipse.dltk.debug.ui.DebugConsoleManager;
import org.eclipse.dltk.debug.ui.Messages;
import org.eclipse.dltk.debug.ui.ScriptDebugElementAdapterFactory;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.dltk.internal.debug.core.model.HotCodeReplaceManager;
import org.eclipse.dltk.internal.debug.ui.ScriptDebugOptionsManager;
import org.eclipse.dltk.internal.debug.ui.ScriptHotCodeReplaceListener;
import org.eclipse.dltk.internal.debug.ui.log.ScriptDebugLogManager;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DLTKDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.debug.ui";
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private static DLTKDebugUIPlugin plugin;
    protected Map<String, IConfigurationElement> fInterpreterInstallTypePageMap;
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);
    private boolean fShuttingDown = false;
    private ScriptHotCodeReplaceListener fHCRListener;
    private HashMap<String, ScriptDebugModelPresentation> fPresentations = new HashMap();

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (DLTKDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            DLTKDebugUIPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return DLTKDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public DLTKDebugUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)DebugConsoleManager.getInstance());
        launchManager.addLaunchListener((ILaunchListener)ScriptDebugLogManager.getInstance());
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)ScriptDebugElementAdapterFactory.getInstance(), IScriptVariable.class);
        ScriptDebugOptionsManager.getDefault().startup();
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new IConsoleListener(){

            public void consolesAdded(org.eclipse.ui.console.IConsole[] consoles) {
                int i = 0;
                while (i < consoles.length) {
                    IConsole console;
                    IOConsoleOutputStream stream;
                    if (consoles[i] instanceof IConsole && (stream = (console = (IConsole)consoles[i]).getStream("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM")) != null) {
                        String string = console.getProcess().getLaunch().getAttribute("org.eclipse.dltk.launching.LAUNCH_COMMAND_LINE");
                    }
                    ++i;
                }
            }

            public void consolesRemoved(org.eclipse.ui.console.IConsole[] consoles) {
            }
        });
        this.fHCRListener = new ScriptHotCodeReplaceListener();
        HotCodeReplaceManager.getDefault().addHotCodeReplaceListener((IHotCodeReplaceListener)this.fHCRListener);
        DLTKDebugPlugin.setSourceOffsetRetriever((ISourceOffsetLookup)new ISourceOffsetLookup(){

            public int calculateOffset(IScriptStackFrame frame, int lineNumber, int column, boolean isEndOffset) {
                ISourceModuleDocumentProvider provider;
                IDocument document;
                ILaunch launch = frame.getLaunch();
                ISourceLocator sourceLocator = launch.getSourceLocator();
                Object object = sourceLocator.getSourceElement((IStackFrame)frame);
                if (object instanceof IFile && (document = (provider = DLTKUIPlugin.getDocumentProvider()).getDocument((Object)new FileEditorInput((IFile)object))) != null) {
                    try {
                        if (column >= 0) {
                            return document.getLineOffset(lineNumber - 1) + column;
                        }
                        if (!isEndOffset) {
                            return document.getLineOffset(lineNumber - 1);
                        }
                        IRegion region = document.getLineInformation(lineNumber - 1);
                        return region.getOffset() + region.getLength();
                    }
                    catch (BadLocationException badLocationException) {}
                }
                return -1;
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            DLTKDebugPlugin.setSourceOffsetRetriever(null);
            HotCodeReplaceManager.getDefault().removeHotCodeReplaceListener((IHotCodeReplaceListener)this.fHCRListener);
            this.setShuttingDown(true);
            ScriptDebugOptionsManager.getDefault().shutdown();
            ScriptDebugElementAdapterFactory.getInstance().dispose();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunchListener((ILaunchesListener)DebugConsoleManager.getInstance());
            launchManager.removeLaunchListener((ILaunchListener)ScriptDebugLogManager.getInstance());
            Iterator<Color> e = this.fColorTable.values().iterator();
            while (e.hasNext()) {
                e.next().dispose();
            }
        }
        finally {
            super.stop(context);
        }
    }

    public boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    private void setShuttingDown(boolean value) {
        this.fShuttingDown = value;
    }

    public static DLTKDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DLTKDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DLTKDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        return DLTKUIPlugin.getStandardDisplay();
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(DLTKDebugUIPlugin.getActiveWorkbenchShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)DLTKDebugUIPlugin.getStandardDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode, result){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$result = blArray;
            }

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                this.val$result[0] = dialog.open() == 0;
            }
        });
    }

    public static void log(IStatus status) {
        DLTKDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        DLTKDebugUIPlugin.log((IStatus)new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, message, null));
    }

    public static void log(Throwable e) {
        DLTKDebugUIPlugin.log((IStatus)new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, Messages.DLTKDebugUIPlugin_internalError, e));
    }

    public static void errorDialog(String message, IStatus status) {
        DLTKDebugUIPlugin.log(status);
        Shell shell = DLTKDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)"DebugUIM0essages.JDIDebugUIPlugin_Error_1", (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        DLTKDebugUIPlugin.log(t);
        Shell shell = DLTKDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, "Error logged from DLTK Debug UI: ", t);
            ErrorDialog.openError((Shell)shell, (String)"DebugUIMessages.JDIDebugUIPlugin_Error_1", (String)message, (IStatus)status);
        }
    }

    public ILaunchConfigurationTab getInterpreterInstallTypePage(String InterpreterInstallTypeID) {
        if (this.fInterpreterInstallTypePageMap == null) {
            this.initializeInterpreterInstallTypePageMap();
        }
        IConfigurationElement configElement = this.fInterpreterInstallTypePageMap.get(InterpreterInstallTypeID);
        ILaunchConfigurationTab tab = null;
        if (configElement != null) {
            try {
                tab = (ILaunchConfigurationTab)configElement.createExecutableExtension("class");
            }
            catch (CoreException ce) {
                DLTKDebugUIPlugin.log((IStatus)new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, "DebugUIMessages.JDIDebugUIPlugin_An_error_occurred_retrieving_a_InterpreterInstallType_page_1", (Throwable)ce));
            }
        }
        return tab;
    }

    protected void initializeInterpreterInstallTypePageMap() {
        this.fInterpreterInstallTypePageMap = new HashMap<String, IConfigurationElement>(10);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DLTKDebugUIPlugin.getUniqueIdentifier(), "interpreterInstallTypePage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute("interpreterInstallTypeID");
            this.fInterpreterInstallTypePageMap.put(id, infos[i]);
            ++i;
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = DLTKDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    private static ScriptDebugModelPresentation loadDebugModelPresentation(String modelId) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.debug.ui", "debugModelPresentations");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement elt = configElements[j];
                    String id = elt.getAttribute("id");
                    if (id != null && id.equals(modelId)) {
                        try {
                            return (ScriptDebugModelPresentation)((Object)elt.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            DLTKDebugUIPlugin.log(e);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public synchronized ScriptDebugModelPresentation getModelPresentation(String modelId) {
        if (!this.fPresentations.containsKey(modelId)) {
            this.fPresentations.put(modelId, DLTKDebugUIPlugin.loadDebugModelPresentation(modelId));
        }
        return this.fPresentations.get(modelId);
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }
}

