/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.javascript.internal.core.RRecordMember;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeExtension;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.emf.common.util.EList;

class RRecordType
extends RType
implements IRRecordType,
IRTypeExtension {
    private final Map<String, IRRecordMember> members = new LinkedHashMap<String, IRRecordMember>();

    public RRecordType() {
    }

    public RRecordType(ITypeSystem context, Collection<Member> members) {
        for (Member member : members) {
            JSType type = member.getType();
            this.members.put(member.getName(), new RRecordMember(member.getName(), type != null ? RTypes.create(context, type) : RTypes.any(), member));
        }
    }

    public RRecordType(Collection<IRRecordMember> members) {
        for (IRRecordMember member : members) {
            this.members.put(member.getName(), member);
        }
    }

    @Override
    public void init(ITypeSystem context, EList<Member> members) {
        for (Member member : members) {
            JSType type = member.getType();
            this.members.put(member.getName(), new RRecordMember(member.getName(), type != null ? RTypes.create(context, type) : RTypes.any(), member));
        }
    }

    @Override
    public String toString(Set<RType> processed) {
        if (!processed.add(this)) {
            return "{_self}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (IRRecordMember member : this.members.values()) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append(member.getName());
            if (member.getType() != RTypes.any()) {
                sb.append(':');
                if (member.getType() instanceof RType) {
                    sb.append(((RType)member.getType()).toString(processed));
                } else {
                    sb.append(member.getType().getName());
                }
            }
            if (!member.isOptional()) continue;
            sb.append('=');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.toString(new HashSet<RType>());
    }

    @Override
    public IRRecordMember getMember(String name) {
        return this.members.get(name);
    }

    @Override
    public Collection<IRRecordMember> getMembers() {
        return this.members.values();
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (super.isAssignableFrom(type).ok()) {
            return TypeCompatibility.TRUE;
        }
        if (type instanceof RRecordType) {
            return this.assignableFromRecordType((RRecordType)type);
        }
        return TypeCompatibility.FALSE;
    }

    private TypeCompatibility assignableFromRecordType(RRecordType other) {
        Map<String, IRRecordMember> others = other.members;
        int hits = 0;
        for (Map.Entry<String, IRRecordMember> entry : others.entrySet()) {
            IRRecordMember member = this.members.get(entry.getKey());
            if (member == null) continue;
            if (!member.getType().isAssignableFrom(entry.getValue().getType()).ok()) {
                return TypeCompatibility.FALSE;
            }
            ++hits;
        }
        for (Map.Entry<String, IRRecordMember> entry : this.members.entrySet()) {
            if (entry.getValue().isOptional() || others.containsKey(entry.getKey())) continue;
            return TypeCompatibility.FALSE;
        }
        return hits != 0 ? TypeCompatibility.TRUE : TypeCompatibility.FALSE;
    }

    @Override
    public IValidationStatus isAssignableFrom(IValueReference argument) {
        if (argument == null) {
            return TypeCompatibility.TRUE;
        }
        IRRecordType other = RTypes.recordType(argument);
        return other != RTypes.emptyRecordType() ? this.assignableFromRecordType((RRecordType)other) : TypeCompatibility.FALSE;
    }

    public int hashCode() {
        return this.members.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RRecordType) {
            RRecordType other = (RRecordType)obj;
            return this.members.equals(other.members);
        }
        return false;
    }
}

