/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow;

import java.util.Map;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.VariableBinding;
import org.eclipse.dltk.javascript.core.dom.Identifier;

public class FlowContext {
    private boolean fConsiderAccessMode;
    private Mode fComputeMode;
    private VariableBinding[] fLocals;
    private Map<Identifier, VariableBinding> fBindings;

    public FlowContext(Map<Identifier, VariableBinding> bindings) {
        this.fBindings = bindings;
    }

    public void setConsiderAccessMode(boolean b) {
        this.fConsiderAccessMode = b;
    }

    public void setComputeMode(Mode mode) {
        this.fComputeMode = mode;
    }

    int getArrayLength() {
        return this.fBindings.size();
    }

    boolean considerAccessMode() {
        return this.fConsiderAccessMode;
    }

    boolean computeMerge() {
        return this.fComputeMode == Mode.MERGE;
    }

    boolean computeArguments() {
        return this.fComputeMode == Mode.ARGUMENTS;
    }

    boolean computeReturnValues() {
        return this.fComputeMode == Mode.RETURN_VALUES;
    }

    public VariableBinding getLocalFromIndex(int index) {
        if (this.fLocals == null || index > this.fLocals.length) {
            return null;
        }
        return this.fLocals[index];
    }

    void manageLocal(VariableBinding local) {
        if (this.fLocals == null) {
            this.fLocals = new VariableBinding[this.fBindings.size()];
        }
        this.fLocals[local.getVariableId()] = local;
    }

    VariableBinding resolve(Identifier id) {
        return this.fBindings.get(id);
    }

    public static enum Mode {
        MERGE,
        ARGUMENTS,
        RETURN_VALUES;

    }
}

