/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.quickfix;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.dltk.compiler.problem.ProblemCategoryManager;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.internal.ui.quickfix.CreateLocalVariableQuickFix;
import org.eclipse.dltk.javascript.internal.ui.quickfix.CreateTopLevelVariable;
import org.eclipse.dltk.javascript.internal.ui.quickfix.GenerateSuppressWarningsResolution;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IAnnotationResolution;
import org.eclipse.dltk.ui.text.IScriptCorrectionContext;
import org.eclipse.dltk.ui.text.IScriptCorrectionProcessor;

public class JSScriptCorrectionProcessor
implements IScriptCorrectionProcessor {
    public boolean canFix(IScriptAnnotation annotation) {
        if (annotation.getId() == JavaScriptProblems.UNDECLARED_VARIABLE) {
            return true;
        }
        return ProblemCategoryManager.getInstance().getID("org.eclipse.dltk.javascript.core.nature", "@SuppressWarnings", annotation.getId()) != null;
    }

    public boolean canFix(IMarker marker) {
        return false;
    }

    public void computeQuickAssistProposals(IScriptAnnotation annotation, IScriptCorrectionContext context) {
        if (annotation.getId() == JavaScriptProblems.UNDECLARED_VARIABLE) {
            context.addResolution((IAnnotationResolution)new CreateLocalVariableQuickFix((IFile)annotation.getSourceModule().getResource(), context.getInvocationContext().getOffset()), annotation);
            CreateTopLevelVariable resolution = new CreateTopLevelVariable((IFile)annotation.getSourceModule().getResource(), context.getInvocationContext().getOffset());
            if (resolution.isValid()) {
                context.addResolution((IAnnotationResolution)resolution, annotation);
            }
        } else {
            String[] id = ProblemCategoryManager.getInstance().getID("org.eclipse.dltk.javascript.core.nature", "@SuppressWarnings", annotation.getId());
            int i = 0;
            while (i < id.length) {
                GenerateSuppressWarningsResolution resolution = new GenerateSuppressWarningsResolution((IFile)annotation.getSourceModule().getResource(), context.getInvocationContext().getOffset(), id[i]);
                if (resolution.isValid()) {
                    context.addResolution((IAnnotationResolution)resolution, annotation);
                }
                ++i;
            }
        }
    }

    public void computeQuickAssistProposals(IMarker marker, IScriptCorrectionContext context) {
    }
}

