/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keywords;

public class BinaryOperation
extends Expression {
    private int operation = -1;
    private Expression left;
    private Expression right;
    private int operationPos = -1;

    public BinaryOperation(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.left != null) {
                this.left.traverse(visitor);
            }
            if (this.right != null) {
                this.right.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperationPosition() {
        return this.operationPos;
    }

    public void setOperationPosition(int operationPos) {
        this.operationPos = operationPos;
    }

    public String getOperationText() {
        return Keywords.fromToken(this.operation);
    }

    public Expression getLeftExpression() {
        return this.left;
    }

    public void setLeftExpression(Expression left) {
        this.left = left;
    }

    public Expression getRightExpression() {
        return this.right;
    }

    public void setRightExpression(Expression right) {
        this.right = right;
    }

    @Override
    public Comment getDocumentation() {
        Comment comment = null;
        if (this.left != null && (comment = this.left.getDocumentation()) != null) {
            return comment;
        }
        if (this.right != null && (comment = this.right.getDocumentation()) != null) {
            return comment;
        }
        return super.getDocumentation();
    }

    @Override
    public String toSourceString(String indentionString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.operationPos > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.left.toSourceString(indentionString));
        buffer.append(' ');
        buffer.append(this.getOperationText());
        buffer.append(' ');
        buffer.append(this.right.toSourceString(indentionString));
        return buffer.toString();
    }

    public boolean isAssignment() {
        return this.operation == 104 || this.operation == 105 || this.operation == 106 || this.operation == 107 || this.operation == 116 || this.operation == 108 || this.operation == 112 || this.operation == 113 || this.operation == 114 || this.operation == 109 || this.operation == 110 || this.operation == 111;
    }

    public boolean isAssignmentTo(Expression expression) {
        return expression == this.left && this.isAssignment();
    }
}

