/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.launching.RubyLaunchConfigurationDelegate;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestingEngine;
import org.eclipse.dltk.testing.TestingEngineManager;

public class RubyTestingLaunchConfigurationDelegate
extends RubyLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static boolean isContainerMode(ILaunchConfiguration configuration) throws CoreException {
        String containerHandle = configuration.getAttribute("org.eclipse.dltk.testing.CONTAINER", "");
        return containerHandle.length() > 0;
    }

    protected void validateLaunchConfiguration(ILaunchConfiguration configuration, String mode, IProject project) throws CoreException {
        super.validateLaunchConfiguration(configuration, mode, project);
        ITestingEngine engine = this.getTestingEngine(configuration);
        if (engine == null) {
            this.abort(DLTKTestingMessages.TestingNoEngineConfigured, null, 111);
        }
        if (RubyTestingLaunchConfigurationDelegate.isContainerMode(configuration)) {
            String containerHandle = configuration.getAttribute("org.eclipse.dltk.testing.CONTAINER", "");
            Assert.isLegal((containerHandle.length() != 0 ? 1 : 0) != 0);
            IModelElement containerElement = DLTKCore.create((String)containerHandle);
            if (containerElement == null) {
                this.abort(DLTKTestingMessages.JUnitLaunchConfigurationTab_error_noContainer, null, 106);
            }
        }
    }

    protected String getScriptLaunchPath(ILaunchConfiguration configuration, IEnvironment scriptEnvironment) throws CoreException {
        ITestingEngine engine = this.getTestingEngine(configuration);
        String mainScript = engine.getMainScriptPath(configuration, scriptEnvironment);
        if (mainScript != null) {
            return mainScript;
        }
        return super.getScriptLaunchPath(configuration, scriptEnvironment);
    }

    protected IPath getDefaultWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        if (RubyTestingLaunchConfigurationDelegate.isContainerMode(configuration)) {
            return new Path(this.getProjectLocation(configuration));
        }
        return super.getDefaultWorkingDirectory(configuration);
    }

    protected void runRunner(ILaunchConfiguration configuration, IInterpreterRunner runner, InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        DLTKTestingPlugin.getModel().start();
        ITestingEngine engine = this.getTestingEngine(configuration);
        engine.configureLaunch(config, configuration, launch);
        super.runRunner(configuration, runner, config, launch, monitor);
    }

    private ITestingEngine getTestingEngine(ILaunchConfiguration configuration) throws CoreException {
        return TestingEngineManager.getEngine((String)configuration.getAttribute("org.eclipse.dltk.testing.engineId", null));
    }
}

