/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.codeassist.AssistParser;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ICompletionNameProvider;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.codeassist.complete.CompletionNodeFound;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.lookup.Scope;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;
import org.eclipse.dltk.tcl.core.extensions.ICompletionExtension;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.internal.core.TclExtensionManager;
import org.eclipse.dltk.tcl.internal.core.codeassist.FieldNameProvider;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclResolver;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordArgumentOrFunctionArgument;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnVariable;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.TclCompletionParser;
import org.eclipse.dltk.tcl.internal.core.packages.TclBuildPathPackageCollector;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinUtils;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclNamespaceImport;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclProc;
import org.eclipse.dltk.tcl.internal.parser.OldTclParserUtils;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclCompletionEngine
extends ScriptCompletionEngine {
    protected AssistParser parser;
    protected ISourceModule sourceModule;
    protected static final boolean TRACE_COMPLETION_TIME = false;
    private ICompletionExtension[] extensions = TclExtensionManager.getDefault().getCompletionExtensions();
    private TclBuildPathPackageCollector packageCollector;
    public static final ICompletionNameProvider<IField> FIELD_NAME_PROVIDER = new ICompletionNameProvider<IField>(){

        public String getCompletion(IField t) {
            return null;
        }

        public String getName(IField t) {
            return t.getElementName();
        }
    };

    public TclCompletionEngine() {
        this.parser = new AssistParser((IAssistParser)new TclCompletionParser(this.extensions));
    }

    public void complete(IModuleSource sourceModule, int completionPosition, int pos) {
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        this.sourceModule = (ISourceModule)sourceModule.getModelElement();
        if (VERBOSE) {
            System.out.print("COMPLETION IN ");
            System.out.print(sourceModule.getFileName());
            System.out.print(" AT POSITION ");
            System.out.println(completionPosition);
            System.out.println("COMPLETION - Source :");
            System.out.println(sourceModule.getSourceContents());
        }
        this.requestor.beginReporting();
        boolean contextAccepted = false;
        try {
            try {
                block22: {
                    ModuleDeclaration parsedUnit;
                    block21: {
                        this.actualCompletionPosition = completionPosition;
                        this.offset = pos;
                        parsedUnit = this.parser.parse(sourceModule);
                        this.packageCollector = new TclBuildPathPackageCollector();
                        try {
                            parsedUnit.traverse((ASTVisitor)this.packageCollector);
                        }
                        catch (Exception e1) {
                            if (!DLTKCore.DEBUG) break block21;
                            e1.printStackTrace();
                        }
                    }
                    if (parsedUnit != null) {
                        if (VERBOSE) {
                            System.out.println("COMPLETION - Diet AST :");
                            System.out.println(parsedUnit.toString());
                        }
                        try {
                            this.source = sourceModule.getContentsAsCharArray();
                            this.parser.parseBlockStatements(parsedUnit, this.actualCompletionPosition);
                            if (VERBOSE) {
                                System.out.println("COMPLETION - AST :");
                                System.out.println(parsedUnit.toString());
                            }
                        }
                        catch (CompletionNodeFound e) {
                            if (e.astNode == null) break block22;
                            if (VERBOSE) {
                                System.out.print("COMPLETION - Completion node : ");
                                System.out.println(e.astNode.toString());
                                if (this.parser.getAssistNodeParent() != null) {
                                    System.out.print("COMPLETION - Parent Node : ");
                                    System.out.println(this.parser.getAssistNodeParent());
                                }
                            }
                            contextAccepted = this.complete(e.astNode, this.parser.getAssistNodeParent(), e.scope, e.insideTypeAnnotation);
                        }
                    }
                }
                if (this.noProposal && this.problem != null) {
                    if (!contextAccepted) {
                        contextAccepted = true;
                        CompletionContext context = new CompletionContext();
                        context.setOffset(completionPosition);
                        context.setTokenKind(0);
                        this.requestor.acceptContext(context);
                    }
                    this.requestor.completionFailure((IProblem)this.problem);
                    if (DEBUG) {
                        this.printDebug(this.problem);
                    }
                }
            }
            catch (OperationCanceledException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                if (!contextAccepted) {
                    contextAccepted = true;
                    CompletionContext context = new CompletionContext();
                    context.setTokenKind(0);
                    context.setOffset(completionPosition);
                    this.requestor.acceptContext(context);
                }
                this.requestor.endReporting();
                p.done("org.eclipse.dltk.tcl.core.nature", "Completion time", 0L);
            }
        }
        finally {
            if (!contextAccepted) {
                contextAccepted = true;
                CompletionContext context = new CompletionContext();
                context.setTokenKind(0);
                context.setOffset(completionPosition);
                this.requestor.acceptContext(context);
            }
            this.requestor.endReporting();
            p.done("org.eclipse.dltk.tcl.core.nature", "Completion time", 0L);
        }
    }

    protected boolean complete(ASTNode astNode, ASTNode astNodeParent, Scope scope, boolean insideTypeAnnotation) {
        this.setSourceRange(astNode.sourceStart(), astNode.sourceEnd());
        int i = 0;
        while (i < this.extensions.length) {
            this.extensions[i].setRequestor(this.getRequestor());
            ++i;
        }
        if (astNode instanceof CompletionOnKeywordOrFunction) {
            CompletionOnKeywordOrFunction key = (CompletionOnKeywordOrFunction)astNode;
            this.processCompletionOnKeywords(key, key.getName());
            this.processCompletionOnFunctions(astNodeParent, key);
            int i2 = 0;
            while (i2 < this.extensions.length) {
                this.extensions[i2].completeOnKeywordOrFunction(key, astNodeParent, this);
                ++i2;
            }
            if (key.getToken().length == 0) {
                this.findVariables(key.getToken(), key.getInParent(), true, astNode.sourceStart(), key.canCompleteEmptyToken(), null);
            }
        } else if (astNode instanceof CompletionOnVariable) {
            this.processCompletionOnVariables(astNode);
            i = 0;
            while (i < this.extensions.length) {
                this.extensions[i].completeOnVariables((CompletionOnVariable)astNode, this);
                ++i;
            }
        } else if (astNode instanceof TclPackageDeclaration) {
            TclPackageDeclaration pkg = (TclPackageDeclaration)astNode;
            int len = this.actualCompletionPosition - pkg.getNameStart();
            String token = "";
            if (len <= pkg.getName().length()) {
                token = pkg.getName().substring(0, len);
            }
            this.setSourceRange(pkg.getNameStart(), pkg.getNameEnd());
            this.packageNamesCompletion(token.toCharArray(), new HashSet<String>());
        } else if (astNode instanceof CompletionOnKeywordArgumentOrFunctionArgument) {
            Expression at;
            CompletionOnKeywordArgumentOrFunctionArgument compl = (CompletionOnKeywordArgumentOrFunctionArgument)astNode;
            TclStatement st = compl.getStatement();
            HashSet<String> methodNames = new HashSet<String>();
            if (st.getCount() >= 1 && (at = st.getAt(0)) instanceof SimpleReference) {
                Expression at1;
                String name = ((SimpleReference)at).getName();
                if (compl.sourceStart() < at.sourceEnd() || this.requestor.isContextInformationMode()) {
                    this.processCompletionOnFunctions(astNodeParent, name.toCharArray(), false);
                }
                String token = null;
                if (compl.argumentIndex() == 1) {
                    token = compl.getName();
                } else if (st.getCount() > 1 && (at1 = st.getAt(1)) instanceof SimpleReference) {
                    token = ((SimpleReference)at1).getName();
                }
                if (DEBUG) {
                    System.out.println("compl.argumentIndex=" + compl.argumentIndex());
                    System.out.println("name='" + name + "'");
                    System.out.println("token='" + token);
                }
                if (token != null) {
                    this.processPartOfKeywords(st.sourceStart(), compl, String.valueOf(name) + " " + token, methodNames);
                    int i3 = 0;
                    while (i3 < this.extensions.length) {
                        this.extensions[i3].completeOnKeywordArgumentsOne(name, token.toCharArray(), compl, methodNames, st, this);
                        ++i3;
                    }
                }
            }
            if (!this.requestor.isContextInformationMode() && (compl.argumentIndex() == 3 || compl.argumentIndex() == -1 && st.getCount() > 1)) {
                Expression at0 = st.getAt(0);
                Expression at1 = st.getAt(1);
                if (at1 instanceof SimpleReference && at0 instanceof SimpleReference) {
                    String sat0 = ((SimpleReference)at0).getName();
                    String sat1 = ((SimpleReference)at1).getName();
                    if ("package".equals(sat0) && "require".equals(sat1)) {
                        this.packageNamesCompletion(compl.getToken(), methodNames);
                        return true;
                    }
                }
            }
            boolean provideDollar = true;
            if (compl.getToken().length > 0 && compl.getToken()[0] == '$') {
                provideDollar = true;
                this.findVariables(compl.getToken(), astNodeParent, true, astNode.sourceStart(), provideDollar, null);
            }
        }
        return true;
    }

    private void packageNamesCompletion(char[] token, Set<String> methodNames) {
        block8: {
            IScriptProject project = this.sourceModule.getScriptProject();
            try {
                IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
                if (install != null) {
                    List<TclPackageInfo> packageNames = TclPackagesManager.getPackageInfos(install);
                    HashSet<String> added = new HashSet<String>();
                    ArrayList<String> k = new ArrayList<String>();
                    String prefix = new String(token);
                    Iterator<TclPackageInfo> iterator = packageNames.iterator();
                    while (iterator.hasNext()) {
                        String kkw = iterator.next().getName();
                        if (kkw.indexOf(36) != -1 || !kkw.startsWith(prefix) || !added.add(kkw)) continue;
                        k.add(kkw);
                    }
                    List<TclModuleInfo> packages = TclPackagesManager.getProjectModules(project.getElementName());
                    if (packages != null) {
                        for (TclModuleInfo tclModuleInfo : packages) {
                            EList<TclSourceEntry> provided = tclModuleInfo.getProvided();
                            for (TclSourceEntry userPkgs : provided) {
                                if (!added.add(userPkgs.getValue())) continue;
                                k.add(userPkgs.getValue());
                            }
                        }
                    }
                    String[] kw = k.toArray(new String[k.size()]);
                    this.findKeywords(token, kw, true);
                    if (methodNames != null) {
                        methodNames.addAll(k);
                    }
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
    }

    protected void processPartOfKeywords(int sourceStart, CompletionOnKeywordArgumentOrFunctionArgument compl, String prefix, Set<String> methodNames) {
        if (!this.requestor.isIgnored(2)) {
            List<String> k = this.processPartOfKeywords(compl.getPossibleKeywords(), prefix, sourceStart);
            if (methodNames != null) {
                methodNames.addAll(k);
            }
        }
    }

    protected List<String> processPartOfKeywords(String[] keywords, String prefix, int sourceStart) {
        int p;
        if (prefix != null && prefix.length() != 0 && prefix.charAt(0) == ':') {
            String[] doubleColonPrependedKeywords = new String[keywords.length];
            int i = 0;
            while (i < keywords.length) {
                doubleColonPrependedKeywords[i] = "::" + keywords[i];
                ++i;
            }
            keywords = doubleColonPrependedKeywords;
        }
        ArrayList<String> k = new ArrayList<String>();
        if (prefix == null) {
            prefix = "";
        }
        prefix = prefix.trim();
        this.selectKeywords(keywords, prefix, k, this.requestor.isContextInformationMode());
        if (k.isEmpty() && this.requestor.isContextInformationMode() && (p = prefix.indexOf(32)) > 0) {
            this.selectKeywords(keywords, prefix.substring(0, p), k, this.requestor.isContextInformationMode());
        }
        if (this.requestor.isContextInformationMode() || k.size() != 1 || !prefix.equals(k.get(0))) {
            this.reportKeywords(prefix, k, sourceStart);
        }
        return k;
    }

    private void reportKeywords(String prefix, List<String> keywords, int sourceStart) {
        char[] keyword = prefix.toCharArray();
        Iterator<String> iterator = keywords.iterator();
        while (iterator.hasNext()) {
            String kw;
            String choice = kw = iterator.next();
            int relevance = this.computeBaseRelevance();
            relevance += this.computeRelevanceForInterestingProposal();
            relevance += this.computeRelevanceForCaseMatching(keyword, choice);
            relevance += this.computeRelevanceForRestrictions(0);
            this.noProposal = false;
            if (this.requestor.isIgnored(2)) continue;
            CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
            proposal.setName(choice);
            proposal.setCompletion(choice);
            proposal.setReplaceRange(sourceStart - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(relevance);
            proposal.setExtraInfo((Object)prefix);
            this.requestor.accept(proposal);
            if (!DEBUG) continue;
            this.printDebug(proposal);
        }
    }

    private void selectKeywords(String[] possibleKeywords, String prefix, List<String> selection, boolean preferExactMatch) {
        String kkw;
        int i;
        if (preferExactMatch) {
            i = 0;
            while (i < possibleKeywords.length) {
                kkw = possibleKeywords[i];
                if (kkw.equals(prefix)) {
                    selection.add(kkw);
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < possibleKeywords.length) {
            kkw = possibleKeywords[i];
            if (kkw.startsWith(prefix)) {
                selection.add(kkw);
            }
            ++i;
        }
    }

    protected void processCompletionOnVariables(ASTNode astNode) {
        if (!this.requestor.isIgnored(4) && !this.requestor.isIgnored(8)) {
            CompletionOnVariable completion = (CompletionOnVariable)astNode;
            this.findVariables(completion.getToken(), completion.getInNode(), completion.canHandleEmpty(), astNode.sourceStart(), completion.getProvideDollar(), null);
        }
    }

    protected void processCompletionOnFunctions(ASTNode astNodeParent, CompletionOnKeywordOrFunction key) {
        this.processCompletionOnFunctions(astNodeParent, this.removeLastColonFromToken(key.getToken()), key.canCompleteEmptyToken());
    }

    protected void processCompletionOnFunctions(ASTNode astNodeParent, char[] token, boolean canCompleteEmptyToken) {
        if (!this.requestor.isIgnored(5)) {
            ArrayList methodNames = new ArrayList();
            HashSet set = new HashSet();
            this.findLocalFunctions(token, canCompleteEmptyToken, astNodeParent, methodNames, set);
            set.addAll(methodNames);
            this.findNamespaceFunctions(token, set);
            if (astNodeParent instanceof TypeDeclaration && (((TypeDeclaration)astNodeParent).getModifiers() & 0x800) != 0) {
                String namespace = TclParseUtil.getElementFQN(astNodeParent, IMixinRequestor.MIXIN_NAME_SEPARATOR, this.parser.getModule());
                this.findSpecificNamespaceFunctions(token, set, namespace, false);
            }
            this.processImports(token, set, astNodeParent);
        }
    }

    private void processImports(char[] token, Set set, ASTNode astNodeParent) {
        String currentNamespace = TclParseUtil.getElementFQN(astNodeParent, "::", this.getAssistParser().getModule());
        if (token == null) {
            return;
        }
        String t = new String(token);
        if (t.startsWith("::")) {
            t = t.substring(2);
        }
        if (t.startsWith(":")) {
            t = t.substring(1);
        }
        HashSet processed = new HashSet();
        if (t.length() > 0) {
            this.processFindNamespace(token, set, currentNamespace, processed);
            if (!currentNamespace.equals("")) {
                this.processFindNamespace(token, set, "", processed);
            }
        }
    }

    private void processFindNamespace(char[] token, Set set, String currentNamespace, Set processed) {
        String pattern = "@" + currentNamespace + "|*";
        String[] findKeys = TclMixinModel.getInstance().getMixin(this.getSourceModule().getScriptProject()).findKeys(pattern);
        HashSet<String> keys = new HashSet<String>();
        int i = 0;
        while (i < findKeys.length) {
            TclNamespaceImport importSt;
            if (keys.add(findKeys[i]) && (importSt = TclNamespaceImport.parseKey(findKeys[i])) != null && importSt.getNamespace().equals(currentNamespace) && processed.add(importSt.getImportNsName())) {
                this.findSpecificNamespaceFunctions(token, set, importSt.getImportNsName(), true);
            }
            ++i;
        }
    }

    protected void processCompletionOnKeywords(CompletionOnKeywordOrFunction key, String token) {
        if (!this.requestor.isIgnored(2)) {
            this.processPartOfKeywords(key.getPossibleKeywords(), token, this.startPosition);
        }
    }

    public char[] removeLastColonFromToken(char[] token) {
        if (token.length > 2 && token[token.length - 1] == ':' && token[token.length - 2] != ':') {
            char[] co2 = new char[token.length - 1];
            System.arraycopy(token, 0, co2, 0, co2.length);
            return co2;
        }
        return token;
    }

    protected void findNamespaceFunctions(char[] token, Set methodNames) {
        HashSet methods = new HashSet();
        String to_ = new String(token);
        String to = to_;
        if (to.startsWith("::")) {
            to = to.substring(2);
        }
        if (to.length() == 0) {
            return;
        }
        methods.addAll(methodNames);
        this.findMethodFromMixin(methods, String.valueOf(to) + "*");
        methods.removeAll(methodNames);
        this.removeSameFrom(methodNames, methods, to_);
        this.filterInternalAPI(methods, this.parser.getModule());
        this.findMethods(token, false, this.toList(methods));
    }

    protected void findSpecificNamespaceFunctions(char[] token, Set methodNames, String namespace, boolean asImport) {
        if (namespace.endsWith(IMixinRequestor.MIXIN_NAME_SEPARATOR)) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        Set methods = new HashSet();
        String to_ = new String(token);
        String to = to_;
        if (to.startsWith("::")) {
            to = to.substring(2);
        }
        methods.addAll(methodNames);
        this.findMethodFromMixin(methods, String.valueOf(namespace) + IMixinRequestor.MIXIN_NAME_SEPARATOR + to + "*");
        methods.removeAll(methodNames);
        if (asImport) {
            this.filterInternalAPI(methods, this.getAssistParser().getModule());
            methods = this.filterSubNamespaces(methods, namespace);
        }
        List list = this.toList(methods);
        List mNames = this.removeNamespace(list, namespace, asImport);
        this.findMethods(token, true, list, mNames);
    }

    private Set filterSubNamespaces(Set methods, String namespace) {
        HashSet<IMethod> results = new HashSet<IMethod>();
        if (!namespace.startsWith("::")) {
            namespace = "::" + namespace;
        }
        if (!namespace.endsWith("::")) {
            namespace = String.valueOf(namespace) + "::";
        }
        for (IMethod element : methods) {
            String fqn = TclParseUtil.getFQNFromModelElement((IModelElement)element, "::");
            if (fqn.startsWith(namespace)) {
                String substring = fqn.substring(namespace.length());
                if (substring.indexOf("::") != -1) continue;
                results.add(element);
                continue;
            }
            results.add(element);
        }
        return results;
    }

    private List removeNamespace(List methods, String namespace, boolean asImport) {
        ArrayList<String> names = new ArrayList<String>();
        if (!namespace.startsWith("::")) {
            namespace = "::" + namespace;
        }
        if (!namespace.endsWith("::")) {
            namespace = String.valueOf(namespace) + "::";
        }
        for (IModelElement element : methods) {
            String fqn = TclParseUtil.getFQNFromModelElement(element, "::");
            if (fqn.startsWith(namespace)) {
                String substring = fqn.substring(namespace.length());
                names.add(substring);
                continue;
            }
            names.add(fqn);
        }
        return names;
    }

    private void filterInternalAPI(Set methods, final ModuleDeclaration module) {
        HashSet namespaceNames;
        block8: {
            if (!this.getRequestor().isIgnored(16)) {
                return;
            }
            namespaceNames = new HashSet();
            try {
                module.traverse(new ASTVisitor(){

                    public boolean visit(TypeDeclaration s) throws Exception {
                        String ns = TclParseUtil.getElementFQN((ASTNode)s, "::", module);
                        if (!ns.startsWith("::")) {
                            ns = "::" + ns;
                        }
                        namespaceNames.add(ns);
                        String ns2 = ns;
                        while (!((ns2 = TclCompletionEngine.this.getElementNamespace(ns2)) == null || ns2 != null && ns2.equals("::"))) {
                            namespaceNames.add(ns2);
                        }
                        return super.visit(s);
                    }
                });
            }
            catch (Exception e1) {
                if (!DLTKCore.DEBUG) break block8;
                e1.printStackTrace();
            }
        }
        HashSet privateSet = new HashSet();
        for (Object method : methods) {
            if (!(method instanceof IMethod)) continue;
            IMethod m = (IMethod)method;
            try {
                boolean nsHere = false;
                String elemName = TclParseUtil.getFQNFromModelElement((IModelElement)m, "::");
                String elemNSName = this.getElementNamespace(elemName);
                if (elemNSName != null) {
                    nsHere = namespaceNames.contains(elemNSName);
                }
                if (nsHere || Flags.isPublic((int)m.getFlags())) continue;
                privateSet.add(method);
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        for (Object object : privateSet) {
            methods.remove(object);
        }
    }

    private String getElementNamespace(String elemName) {
        int pos = elemName.lastIndexOf("::");
        if (pos != -1) {
            String rs = elemName.substring(0, pos);
            if (rs.length() == 0) {
                return null;
            }
            return rs;
        }
        return null;
    }

    protected void findMethods(char[] token, boolean canCompleteEmptyToken, List methods) {
        this.findMethods(token, canCompleteEmptyToken, methods, 5);
    }

    public void removeSameFrom(Set methodNames, Set elements, String to_) {
        HashSet namesToRemove = new HashSet();
        for (Object name : methodNames) {
            if (!(name instanceof String)) continue;
            namesToRemove.add(name);
        }
        if (!namesToRemove.isEmpty()) {
            Iterator me = elements.iterator();
            while (me.hasNext()) {
                String qname;
                Object m = me.next();
                if (m instanceof IMethod) {
                    qname = this.processMethodName((IMethod)m, to_);
                    if (!namesToRemove.contains(qname)) continue;
                    me.remove();
                    continue;
                }
                if (!(m instanceof IType) || !namesToRemove.contains(qname = this.processTypeName((IType)m, to_))) continue;
                me.remove();
            }
        }
        elements.removeAll(methodNames);
    }

    public void findMixinTclElement(Set completions, String tok, Class mixinClass) {
        String pattern = tok.replaceAll("::", IMixinRequestor.MIXIN_NAME_SEPARATOR);
        IModelElement[] elements = TclMixinUtils.findModelElementsFromMixin(pattern, mixinClass, this.scriptProject, this.getProgressMonitor());
        elements = TclResolver.complexFilter(elements, this.scriptProject, this.packageCollector, false);
        Set completionNames = this.calculateCompletionNames(completions);
        int i = 0;
        while (i < elements.length) {
            IModelElement element = elements[i];
            if (this.moduleFilter(completions, element, completionNames)) {
                completions.add(element);
            }
            ++i;
        }
    }

    public void findMixinTclElementNoFilter(Set completions, String tok, Class mixinClass) {
        String pattern = tok.replaceAll("::", IMixinRequestor.MIXIN_NAME_SEPARATOR);
        IModelElement[] elements = TclMixinUtils.findModelElementsFromMixin(pattern, mixinClass, this.scriptProject, this.getProgressMonitor());
        int i = 0;
        while (i < elements.length) {
            completions.add(elements[i]);
            ++i;
        }
    }

    protected void findMethodFromMixin(Set methods, String tok) {
        this.findMixinTclElement(methods, tok, TclProc.class);
    }

    protected boolean moduleFilter(Set completions, IModelElement modelElement, Set completionNames) {
        int i = 0;
        while (i < this.extensions.length) {
            if (!this.extensions[i].modelFilter(completions, modelElement)) {
                return false;
            }
            ++i;
        }
        return completionNames.add(TclCompletionEngine.getFQNFromModelElement(modelElement));
    }

    private Set calculateCompletionNames(Set completions) {
        HashSet result = new HashSet();
        for (Object o : completions) {
            if (!(o instanceof IModelElement)) {
                if (!(o instanceof String)) continue;
                result.add(o);
                continue;
            }
            IModelElement element = (IModelElement)o;
            result.add(TclCompletionEngine.getFQNFromModelElement(element));
        }
        return result;
    }

    private static final String getFQNFromModelElement(IModelElement element) {
        return TclParseUtil.getFQNFromModelElement(element, "::");
    }

    public <T> List<T> toList(Set<T> types) {
        return new ArrayList<T>(types);
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, 8, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected void findLocalFunctions(char[] token, boolean canCompleteEmptyToken, ASTNode astNodeParent, List methodNames, Set set) {
        token = this.removeLastColonFromToken(token);
        ArrayList methods = new ArrayList();
        this.fillFunctionsByLevels(token, astNodeParent, methods, methodNames);
        ArrayList<IModelElement> nodeMethods = new ArrayList<IModelElement>();
        ArrayList nodeMethodNames = new ArrayList();
        ArrayList<MethodDeclaration> otherMethods = new ArrayList<MethodDeclaration>();
        ArrayList otherMethodNames = new ArrayList();
        TclResolver resolver = new TclResolver(this.sourceModule, this.parser.getModule());
        if (methods.size() > 0) {
            int i = 0;
            while (i < methods.size()) {
                MethodDeclaration method = (MethodDeclaration)methods.get(i);
                IModelElement modelElement = resolver.findModelElementFrom((ASTNode)method);
                if (modelElement != null) {
                    nodeMethods.add(modelElement);
                    set.add(modelElement);
                    nodeMethodNames.add(methodNames.get(i));
                } else {
                    otherMethods.add(method);
                    otherMethodNames.add(methodNames.get(i));
                }
                ++i;
            }
            this.findMethods(token, canCompleteEmptyToken, nodeMethods, nodeMethodNames);
            this.findLocalMethods(token, canCompleteEmptyToken, otherMethods, otherMethodNames);
        }
    }

    private void fillFunctionsByLevels(char[] token, ASTNode parent, List methods, List gmethodNames) {
        List<ASTNode> levels = TclParseUtil.findLevelsTo(this.parser.getModule(), parent);
        int len = levels.size();
        ArrayList visited = new ArrayList();
        ArrayList methodNames = new ArrayList();
        int j = 0;
        while (j < len) {
            List statements;
            TypeDeclaration decl;
            ASTNode astNodeParent = levels.get(len - 1 - j);
            boolean topLevel = false;
            if (token != null && token.length > 0 && token[0] == ':') {
                topLevel = true;
            }
            if (astNodeParent instanceof TypeDeclaration && !topLevel) {
                decl = (TypeDeclaration)astNodeParent;
                statements = decl.getStatements();
                if (statements != null) {
                    this.processMethods(methods, methodNames, statements, "", visited, parent);
                }
            } else if (astNodeParent instanceof ModuleDeclaration && (statements = (decl = (ModuleDeclaration)astNodeParent).getStatements()) != null) {
                this.processMethods(methods, methodNames, statements, topLevel ? "::" : "", visited, parent);
            }
            ++j;
        }
        gmethodNames.addAll(methodNames);
    }

    private void processMethods(List methods, List methodNames, List statements, String namePrefix, List visited, ASTNode realParent) {
        int i = 0;
        while (i < statements.size()) {
            block12: {
                ASTNode nde;
                block13: {
                    String prefix;
                    String name;
                    block11: {
                        nde = (ASTNode)statements.get(i);
                        if (!(nde instanceof MethodDeclaration)) break block11;
                        if (!this.isTclMethod((MethodDeclaration)nde)) break block12;
                        String mName = ((MethodDeclaration)nde).getName();
                        if (!mName.startsWith("::")) {
                            mName = String.valueOf(namePrefix) + mName;
                        }
                        if (realParent instanceof MethodDeclaration) {
                            name = ((MethodDeclaration)realParent).getName();
                            prefix = String.valueOf(namePrefix) + ((MethodDeclaration)nde).getName();
                            if (name.startsWith("::") && !prefix.startsWith("::")) {
                                prefix = "::" + prefix;
                            }
                            if (!name.equals(prefix)) {
                                String nn;
                                String p2;
                                String p1;
                                int i1 = name.lastIndexOf("::");
                                int i2 = prefix.lastIndexOf("::");
                                if (i1 != -1 && i2 != -1 && (p1 = name.substring(0, i1)).startsWith(p2 = prefix.substring(0, i2)) && !methodNames.contains(nn = prefix.substring(i2 + 2)) && this.methodCanBeAdded(nde, realParent, mName)) {
                                    methods.add(nde);
                                    methodNames.add(nn);
                                }
                            }
                        }
                        if (!methodNames.contains(mName) && this.methodCanBeAdded(nde, realParent, mName)) {
                            methods.add(nde);
                            methodNames.add(mName);
                        }
                        break block13;
                    }
                    if (nde instanceof TypeDeclaration && !visited.contains(nde)) {
                        String nn;
                        List tStatements = ((TypeDeclaration)nde).getStatements();
                        visited.add(nde);
                        if (realParent instanceof MethodDeclaration) {
                            name = ((MethodDeclaration)realParent).getName();
                            prefix = String.valueOf(namePrefix) + ((TypeDeclaration)nde).getName();
                            if (name.startsWith("::") && !prefix.startsWith("::")) {
                                prefix = "::" + prefix;
                            }
                            if (name.startsWith(namePrefix)) {
                                this.processMethods2(methods, methodNames, tStatements, "", realParent);
                            }
                        }
                        String nextPrefix = (nn = ((TypeDeclaration)nde).getName()).startsWith("::") ? nn : String.valueOf(namePrefix) + nn;
                        this.processMethods(methods, methodNames, tStatements, String.valueOf(nextPrefix) + "::", visited, realParent);
                    }
                }
                visited.add(nde);
            }
            ++i;
        }
    }

    private boolean isTclMethod(MethodDeclaration nde) {
        int modifiers = nde.getModifiers();
        return modifiers < 524288;
    }

    private boolean isTclType(TypeDeclaration nde) {
        int modifiers = nde.getModifiers();
        return modifiers < 524288;
    }

    private boolean isTclField(FieldDeclaration nde) {
        int modifiers = nde.getModifiers();
        return modifiers < 524288;
    }

    protected boolean methodCanBeAdded(ASTNode nde, ASTNode realParent, String mName) {
        String realParentFQN = TclParseUtil.getElementFQN(TclParseUtil.getPrevParent(this.parser.getModule(), realParent), "::", this.parser.getModule());
        String ndeFQN = TclParseUtil.getElementFQN(TclParseUtil.getPrevParent(this.parser.getModule(), nde), "::", this.parser.getModule());
        if (mName.startsWith("::")) {
            mName = mName.substring(2);
        }
        if (ndeFQN.length() > 0 && mName.startsWith(ndeFQN)) {
            return true;
        }
        return ndeFQN.equals(realParentFQN);
    }

    private void processMethods2(List methods, List methodNames, List statements, String namePrefix, ASTNode realParent) {
        int i = 0;
        while (i < statements.size()) {
            ASTNode nde = (ASTNode)statements.get(i);
            if (nde instanceof MethodDeclaration) {
                String mName = String.valueOf(namePrefix) + ((MethodDeclaration)nde).getName();
                if (mName.startsWith("::::")) {
                    mName = mName.substring(2);
                }
                if (this.isTclMethod((MethodDeclaration)nde) && !methodNames.contains(mName) && !methods.contains(nde) && this.methodCanBeAdded(nde, realParent, mName)) {
                    methods.add(nde);
                    methodNames.add(mName);
                }
            } else if (nde instanceof TypeDeclaration) {
                List tStatements = ((TypeDeclaration)nde).getStatements();
                this.processMethods2(methods, methodNames, tStatements, String.valueOf(namePrefix) + ((TypeDeclaration)nde).getName() + "::", realParent);
            }
            ++i;
        }
    }

    protected void findVariables(char[] token, ASTNode parent, boolean canCompleteEmptyToken, int beforePosition, boolean provideDollar, List cho) {
        List statements;
        ArrayList choices;
        ArrayList gChoices = new ArrayList();
        if (cho != null) {
            gChoices.addAll(cho);
        }
        if (token.length > 0 && token[0] != '$') {
            provideDollar = false;
        }
        token = this.removeLastColonFromToken(token);
        if (parent instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)parent;
            choices = new ArrayList();
            statements = method.getArguments();
            if (statements != null) {
                int i = 0;
                while (i < statements.size()) {
                    Argument a = (Argument)statements.get(i);
                    if (a != null) {
                        String n = a.getName();
                        this.checkAddVariable(choices, n);
                    }
                    ++i;
                }
            }
            statements = method.getStatements();
            this.checkVariableStatements(beforePosition, choices, statements);
            String[] cc = new String[choices.size()];
            int i = 0;
            while (i < choices.size()) {
                cc[i] = (String)choices.get(i);
                gChoices.add(choices.get(i));
                ++i;
            }
            this.findLocalVariables(token, cc, canCompleteEmptyToken, provideDollar);
        } else if (parent instanceof ModuleDeclaration) {
            ModuleDeclaration module = (ModuleDeclaration)parent;
            this.checkVariables(token, canCompleteEmptyToken, beforePosition, module.getStatements(), provideDollar, gChoices);
        } else if (parent instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)parent;
            this.checkVariables(token, canCompleteEmptyToken, beforePosition, type.getStatements(), provideDollar, gChoices);
            String prefix = "";
            if (provideDollar) {
                prefix = "$" + prefix;
            }
            statements = type.getStatements();
            int l = 0;
            while (l < statements.size()) {
                this.findASTVariables((ASTNode)statements.get(l), prefix, token, canCompleteEmptyToken, gChoices);
                ++l;
            }
        }
        String prefix = "";
        choices = new ArrayList();
        if (token.length > 0 && (token[0] == ':' || token[0] == '$') || token.length == 0 || token.length > 2 && token[1] == ':') {
            prefix = "::";
            if (provideDollar) {
                prefix = "$" + prefix;
            }
            this.findASTVariables((ASTNode)this.parser.getModule(), prefix, token, canCompleteEmptyToken, choices);
        }
        int i = 0;
        while (i < gChoices.size()) {
            String cc;
            String c = (String)gChoices.get(i);
            if (choices.contains(c)) {
                choices.remove(c);
            }
            if (c.startsWith("$") && choices.contains(cc = c.substring(1))) {
                choices.remove(cc);
            }
            ++i;
        }
        String[] cc = new String[choices.size()];
        int i2 = 0;
        while (i2 < choices.size()) {
            cc[i2] = (String)choices.get(i2);
            gChoices.add(choices.get(i2));
            ++i2;
        }
        this.findLocalVariables(token, cc, canCompleteEmptyToken, true);
        this.findGlobalVariables(token, gChoices, provideDollar);
        if (!this.checkValidParetNode(parent)) {
            List<ASTNode> findLevelsTo = TclParseUtil.findLevelsTo(this.parser.getModule(), parent);
            Object realParent = null;
            for (ASTNode nde : findLevelsTo) {
                if (!this.checkValidParetNode(nde)) continue;
                realParent = nde;
            }
            if (realParent != null && !realParent.equals(parent)) {
                this.findVariables(token, (ASTNode)realParent, canCompleteEmptyToken, beforePosition, provideDollar, gChoices);
            }
        }
    }

    private boolean checkValidParetNode(ASTNode parent) {
        return parent instanceof MethodDeclaration || parent instanceof ModuleDeclaration || parent instanceof TypeDeclaration;
    }

    private void findGlobalVariables(char[] token, final List choices, final boolean provideDollar) {
        final ArrayList fields = new ArrayList();
        final ArrayList types = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IType) {
                    IType type = (IType)element;
                    if ((type.getFlags() & 0x800) == 0) {
                        return;
                    }
                    if (!(type.getParent() instanceof ISourceModule)) {
                        return;
                    }
                    String tName = type.getTypeQualifiedName();
                    if (!choices.contains(tName)) {
                        types.add(type);
                    }
                    this.processTypeFields(choices, fields, type);
                } else if (element instanceof IField) {
                    IField field = (IField)element;
                    if (!(field.getParent() instanceof ISourceModule)) {
                        return;
                    }
                    String mn = field.getTypeQualifiedName("$", false).replaceAll("\\$", "::");
                    if (!mn.startsWith("::")) {
                        mn = "::" + mn;
                    }
                    if (provideDollar) {
                        mn = "$" + mn;
                    }
                    if (!choices.contains(mn) && !choices.contains(mn.substring(2))) {
                        fields.add(field);
                        choices.add(mn);
                    }
                }
            }

            private void processTypeFields(List methodNames, List methods, IType type) throws ModelException {
                IField[] tmethods = type.getFields();
                int i = 0;
                while (i < tmethods.length) {
                    String mn = tmethods[i].getTypeQualifiedName("$", false).replaceAll("\\$", "::");
                    if (!mn.startsWith("::")) {
                        mn = "::" + mn;
                    }
                    if (!methodNames.contains(mn)) {
                        methods.add(tmethods[i]);
                        methodNames.add(mn);
                    }
                    ++i;
                }
                IType[] types2 = type.getTypes();
                int i2 = 0;
                while (i2 < types2.length) {
                    this.processTypeFields(methodNames, methods, types2[i2]);
                    ++i2;
                }
            }
        };
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.scriptProject);
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        if (token.length >= 1 && token[0] == '$') {
            char[] token2 = new char[token.length - 1];
            int i = 0;
            while (i < token.length - 1) {
                token2[i] = token[i + 1];
                ++i;
            }
            token = token2;
        }
        String to = new String(token);
        if (token != null && token.length >= 3 && token[0] == ':') {
            String[] tokens = TclParseUtil.tclSplit(to);
            if (tokens.length < 2) {
                return;
            }
            String tok = tokens[1];
            try {
                this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
                int nonNoneCount = 0;
                String mtok = null;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].length() > 0) {
                        ++nonNoneCount;
                        if (mtok == null) {
                            mtok = tokens[i];
                        }
                    }
                    ++i;
                }
                if (nonNoneCount == 1 && tok.length() >= 2) {
                    this.search(String.valueOf(mtok) + "*", 2, 0, scope, requestor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (token != null && token.length >= 1 && token[0] != ':') {
            try {
                String[] tokens = TclParseUtil.tclSplit(to);
                if (tokens.length == 0) {
                    return;
                }
                String tok = tokens[0];
                this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
                int nonNoneCount = 0;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].length() > 0) {
                        ++nonNoneCount;
                    }
                    ++i;
                }
                if (nonNoneCount == 1 && tok.length() >= 2) {
                    this.search(String.valueOf(tok) + "*", 2, 0, scope, requestor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.findFields(token, false, fields, new FieldNameProvider(to, provideDollar ? "$" : ""));
    }

    /*
     * Unable to fully structure code
     */
    protected void findASTVariables(ASTNode node, String prefix, char[] token, boolean canCompleteEmptyToken, List choices) {
        block9: {
            statements = null;
            add = "";
            if (node instanceof ModuleDeclaration) {
                statements = ((ModuleDeclaration)node).getStatements();
            } else if (node instanceof TypeDeclaration) {
                if (!this.isTclType((TypeDeclaration)node)) {
                    return;
                }
                statements = ((TypeDeclaration)node).getStatements();
                nme = ((TypeDeclaration)node).getName();
                add = nme.startsWith("::") != false ? String.valueOf(nme.substring(2)) + "::" : String.valueOf(nme) + "::";
            }
            if (statements == null) break block9;
            i = 0;
            while (i < statements.size()) {
                block12: {
                    block11: {
                        block10: {
                            nde = (ASTNode)statements.get(i);
                            if (!(nde instanceof TclStatement)) break block10;
                            variable = OldTclParserUtils.returnVariable((TclStatement)nde);
                            if (variable == null) break block11;
                            u = 0;
                            while (u < variable.length) {
                                prev = this.preProcessVariable(variable[u]).substring(1);
                                var = String.valueOf(prefix) + add;
                                var = var.endsWith("::") != false && prev.startsWith("::") != false ? String.valueOf(var) + prev.substring(2) : String.valueOf(var) + prev;
                                if (!choices.contains(var)) {
                                    choices.add(var);
                                }
                                ++u;
                            }
                            break block12;
                        }
                        if (nde instanceof FieldDeclaration) {
                            field = (FieldDeclaration)nde;
                            if (this.isTclField(field)) {
                                this.checkAddVariable(choices, String.valueOf(prefix) + add + field.getName());
                                ** GOTO lbl40
                            } else {
                                ** GOTO lbl37
                            }
                        }
                        break block11;
lbl37:
                        // 2 sources

                        break block12;
                    }
                    this.findASTVariables(nde, String.valueOf(prefix) + add, token, canCompleteEmptyToken, choices);
                }
                ++i;
            }
        }
    }

    private void checkVariables(char[] token, boolean canCompleteEmptyToken, int beforePosition, List statements, boolean provideDollar, List gChoices) {
        ArrayList choices = new ArrayList();
        this.checkVariableStatements(beforePosition, choices, statements);
        String[] cc = new String[choices.size()];
        int i = 0;
        while (i < choices.size()) {
            cc[i] = (String)choices.get(i);
            gChoices.add(choices.get(i));
            ++i;
        }
        this.findLocalVariables(token, cc, canCompleteEmptyToken, provideDollar);
    }

    protected void checkVariableStatements(int beforePosition, final List choices, List statements) {
        if (statements != null) {
            int i = 0;
            while (i < statements.size()) {
                block9: {
                    ASTNode node = (ASTNode)statements.get(i);
                    if (node instanceof FieldDeclaration) {
                        FieldDeclaration decl = (FieldDeclaration)node;
                        if (this.isTclField(decl)) {
                            this.checkAddVariable(choices, decl.getName());
                        }
                    } else if (node instanceof TclStatement && node.sourceEnd() < beforePosition) {
                        TclStatement s = (TclStatement)node;
                        this.checkTclStatementForVariables(choices, s);
                    } else {
                        ASTVisitor visitor = new ASTVisitor(){

                            public boolean visit(Statement s) throws Exception {
                                if (s instanceof FieldDeclaration) {
                                    String name = TclParseUtil.getElementFQN((ASTNode)s, "::", TclCompletionEngine.this.parser.getModule());
                                    ASTNode pp = TclParseUtil.getScopeParent(TclCompletionEngine.this.parser.getModule(), (ASTNode)s);
                                    boolean isTcl = true;
                                    if (pp instanceof TypeDeclaration) {
                                        isTcl = TclCompletionEngine.this.isTclType((TypeDeclaration)pp);
                                    }
                                    if (pp instanceof MethodDeclaration) {
                                        isTcl = TclCompletionEngine.this.isTclMethod((MethodDeclaration)pp);
                                    }
                                    if (isTcl && TclCompletionEngine.this.isTclField((FieldDeclaration)s)) {
                                        TclCompletionEngine.this.checkAddVariable(choices, name);
                                    }
                                } else if (s instanceof TclStatement) {
                                    TclCompletionEngine.this.checkTclStatementForVariables(choices, (TclStatement)s);
                                }
                                return super.visit(s);
                            }
                        };
                        try {
                            node.traverse(visitor);
                        }
                        catch (Exception e) {
                            if (!DLTKCore.DEBUG) break block9;
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void checkTclStatementForVariables(List choices, TclStatement s) {
        String[] variable = OldTclParserUtils.returnVariable(s);
        if (variable != null) {
            int u = 0;
            while (u < variable.length) {
                this.checkAddVariable(choices, variable[u]);
                ++u;
            }
        }
    }

    protected void checkAddVariable(List choices, String n) {
        String str = this.preProcessVariable(n);
        if (!choices.contains(str)) {
            choices.add(str);
        }
    }

    private String preProcessVariable(String n) {
        if (n.startsWith("$")) {
            return n;
        }
        String str = n.indexOf(32) != -1 ? "${" + n + '}' : "$" + n;
        return str;
    }

    public IAssistParser getAssistParser() {
        return this.parser;
    }

    protected int getEndOfEmptyToken() {
        return this.actualCompletionPosition;
    }

    protected String processMethodName(IMethod method, String tok) {
        return OldTclParserUtils.processMethodName(method, tok);
    }

    protected String processTypeName(IType method, String tok) {
        String name = OldTclParserUtils.processTypeName(method, tok);
        if (name.startsWith("::") && (tok.length() > 1 && tok.charAt(0) != ':' && tok.charAt(1) != ':' || tok.length() == 0)) {
            name = name.substring(2);
        }
        return name;
    }

    public CompletionRequestor getRequestor() {
        return this.requestor;
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    public int getActualCompletionPosition() {
        return this.actualCompletionPosition;
    }
}

