/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ModuleSource;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.javascript.ast.ErrorExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.UserExpression;
import org.eclipse.dltk.javascript.core.NodeFinder;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;

public class JavaScriptCompletionUtil {
    public static ExpressionType evaluateExpressionType(@Nullable ISourceModule module, @NonNull CharSequence document, int position) {
        ExpressionContext context = JavaScriptCompletionUtil.evaluateExpressionContext(module, document, position);
        return context != null ? context.expressionType : null;
    }

    public static ExpressionContext evaluateExpressionContext(ISourceModule module, CharSequence document, int position) {
        Script script = module != null ? JavaScriptParserUtil.parse((ISourceModule)module) : JavaScriptParserUtil.parse((IModuleSource)new ModuleSource(document.toString()), null);
        return JavaScriptCompletionUtil.evaluateExpressionContext(script, document, position);
    }

    private static boolean isDirectlyInObjectInitializer(@NonNull ASTNode node, int position) {
        if (node instanceof UserExpression) {
            node = ((UserExpression)node).getOriginal();
        }
        for (ASTNode child : node.getChilds()) {
            if (child.start() >= position || child.end() <= position) continue;
            return JavaScriptCompletionUtil.isDirectlyInObjectInitializer(child, position);
        }
        return node instanceof ObjectInitializer;
    }

    public static ExpressionContext evaluateExpressionContext(Script script, CharSequence document, int position) {
        if (script != null) {
            ASTNode node = new NodeFinder(true, position, position).locate(script).getNode();
            if (node instanceof Identifier) {
                Identifier identifier = (Identifier)node;
                JSNode parent = identifier.getParent();
                if (!(parent instanceof Script) && !(parent instanceof StatementBlock)) {
                    if (parent instanceof PropertyInitializer && ((PropertyInitializer)parent).getValue() == node) {
                        return new ExpressionContext(ExpressionType.PROPERTY_INITIALIZER_VALUE, (JSNode)identifier);
                    }
                    return new ExpressionContext(ExpressionType.OTHER, (JSNode)identifier);
                }
            } else if (node instanceof ErrorExpression) {
                ErrorExpression error = (ErrorExpression)node;
                if (error.getParent() instanceof PropertyInitializer) {
                    return new ExpressionContext(ExpressionType.PROPERTY_INITIALIZER_VALUE, (JSNode)error);
                }
                return new ExpressionContext(ExpressionType.OTHER, (JSNode)error);
            }
            int begin = position;
            while (begin > 0 && Character.isWhitespace(document.charAt(begin - 1))) {
                --begin;
            }
            node = new NodeFinder(true, begin, begin).locate(script).getNode();
            if (node instanceof ErrorExpression) {
                ErrorExpression error = (ErrorExpression)node;
                if (error.getParent() instanceof PropertyInitializer) {
                    return new ExpressionContext(ExpressionType.PROPERTY_INITIALIZER_VALUE, (JSNode)error);
                }
                return new ExpressionContext(ExpressionType.OTHER, (JSNode)error);
            }
            if (JavaScriptCompletionUtil.isDirectlyInObjectInitializer((ASTNode)script, position)) {
                return new ExpressionContext(ExpressionType.OBJECT_INITIALIZER, null);
            }
        }
        return null;
    }

    public static class ExpressionContext {
        public final ExpressionType expressionType;
        public final JSNode node;

        public ExpressionContext(ExpressionType expressionType, JSNode node) {
            this.expressionType = expressionType;
            this.node = node;
        }
    }

    public static enum ExpressionType {
        PROPERTY_INITIALIZER_VALUE,
        OBJECT_INITIALIZER,
        OTHER;

    }
}

