/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.impl;

import java.util.Collection;
import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.NewExpression;
import org.eclipse.dltk.javascript.core.dom.impl.ExpressionImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class NewExpressionImpl
extends ExpressionImpl
implements NewExpression {
    protected Expression constructor;
    protected EList<Expression> arguments;

    protected NewExpressionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return DomPackage.Literals.NEW_EXPRESSION;
    }

    @Override
    public Expression getConstructor() {
        return this.constructor;
    }

    public NotificationChain basicSetConstructor(Expression newConstructor, NotificationChain msgs) {
        Expression oldConstructor = this.constructor;
        this.constructor = newConstructor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldConstructor, (Object)newConstructor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setConstructor(Expression newConstructor) {
        if (newConstructor != this.constructor) {
            NotificationChain msgs = null;
            if (this.constructor != null) {
                msgs = ((InternalEObject)this.constructor).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newConstructor != null) {
                msgs = ((InternalEObject)newConstructor).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetConstructor(newConstructor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newConstructor, (Object)newConstructor));
        }
    }

    @Override
    public EList<Expression> getArguments() {
        if (this.arguments == null) {
            this.arguments = new EObjectContainmentEList(Expression.class, (InternalEObject)this, 3);
        }
        return this.arguments;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetConstructor(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getArguments()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getConstructor();
            }
            case 3: {
                return this.getArguments();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setConstructor((Expression)newValue);
                return;
            }
            case 3: {
                this.getArguments().clear();
                this.getArguments().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setConstructor(null);
                return;
            }
            case 3: {
                this.getArguments().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.constructor != null;
            }
            case 3: {
                return this.arguments != null && !this.arguments.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

