/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.ti.JSDocSupport;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.NodeFinder;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.scriptdoc.JavaDoc2HTMLTextReader;
import org.eclipse.dltk.javascript.scriptdoc.ScriptDocumentationProvider;
import org.eclipse.dltk.javascript.scriptdoc.StringJavaDocCommentReader;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.ui.documentation.DocumentationUtils;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;

public class JavaScriptProposalInfo
extends ProposalInfo {
    private final Object ref;

    public JavaScriptProposalInfo(Object ref) {
        super(null);
        this.ref = ref;
    }

    public String getInfo(IProgressMonitor monitor) {
        if (this.ref instanceof IMember) {
            Reader contentReader = new ScriptDocumentationProvider().getInfo((IMember)this.ref, true, true);
            if (contentReader != null) {
                String string = this.getString(contentReader);
                return string;
            }
        } else {
            if (this.ref instanceof String) {
                return (String)this.ref;
            }
            if (this.ref instanceof Element) {
                IDocumentationResponse response = ScriptDocumentationAccess.getDocumentation((String)"org.eclipse.dltk.javascript.core.nature", (Object)this.ref, null);
                if (response != null) {
                    try {
                        return this.getString(response.getReader());
                    }
                    catch (IOException e) {
                        JavaScriptUI.log(e);
                    }
                }
            } else {
                if (this.ref instanceof IValueReference) {
                    return this.getInfo(((IValueReference)this.ref).getLocation());
                }
                if (this.ref instanceof IModelBuilder.IMethod) {
                    ISourceRange docRange = ((IModelBuilder.IMethod)this.ref).getDocRange();
                    if (docRange != null && docRange.getOffset() > 0 && docRange.getLength() > 0) {
                        ISourceModule sourceModule = ((IModelBuilder.IMethod)this.ref).getLocation().getSourceModule();
                        try {
                            String comment = sourceModule.getSource().substring(docRange.getOffset(), docRange.getOffset() + docRange.getLength());
                            return this.getString((Reader)((Object)new JavaDoc2HTMLTextReader((Reader)((Object)new StringJavaDocCommentReader(comment)))));
                        }
                        catch (ModelException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (this.ref instanceof IModelBuilder.IVariable) {
                    return this.getInfo(((IModelBuilder.IVariable)this.ref).getLocation());
                }
            }
        }
        return null;
    }

    private String getInfo(final ReferenceLocation location) {
        Comment comment;
        ISourceModule m;
        block6: {
            if (location == ReferenceLocation.UNKNOWN) {
                return null;
            }
            m = location.getSourceModule();
            if (m == null) {
                return null;
            }
            try {
                m.accept(new IModelElementVisitor(){

                    public boolean visit(IModelElement element) {
                        if (element instanceof IMember) {
                            try {
                                ISourceRange nameRange = ((IMember)element).getNameRange();
                                if (location.getNameStart() >= nameRange.getOffset() && location.getNameEnd() <= nameRange.getOffset() + nameRange.getLength()) {
                                    throw new ModelElementFound(element);
                                }
                            }
                            catch (ModelException e) {
                                e.printStackTrace();
                            }
                        }
                        return true;
                    }
                });
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            catch (ModelElementFound found) {
                Reader contentReader = new ScriptDocumentationProvider().getInfo((IMember)found.element, true, true);
                if (contentReader == null) break block6;
                return this.getString(contentReader);
            }
        }
        Script script = JavaScriptParserUtil.parse((ISourceModule)m, null);
        NodeFinder nodeFinder = new NodeFinder(location.getNameStart(), location.getNameEnd());
        nodeFinder.locate(script);
        ASTNode node = nodeFinder.getNode();
        if (node instanceof JSNode && (comment = JSDocSupport.getComment((JSNode)((JSNode)node))) != null && comment.getText().length() > 0) {
            return this.getString((Reader)((Object)new JavaDoc2HTMLTextReader((Reader)((Object)new StringJavaDocCommentReader(comment.getText())))));
        }
        return null;
    }

    private String getString(Reader reader) {
        return DocumentationUtils.readAll((Reader)reader);
    }

    private static class ModelElementFound
    extends RuntimeException {
        final IModelElement element;

        public ModelElementFound(IModelElement element) {
            this.element = element;
        }
    }
}

