/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring;

import org.eclipse.core.runtime.Assert;

public class ParameterInfo {
    public static final int INDEX_FOR_ADDED = -1;
    public static final String DEFAULT_VALUE = "undefined";
    private final String fOldName;
    private final String fOldTypeName;
    private final int fOldIndex;
    private String fNewTypeName;
    private String fDefaultValue;
    private String fNewName;
    private boolean fIsDeleted;

    public ParameterInfo(String type, String name, int index) {
        this.fOldTypeName = type;
        this.fNewTypeName = type;
        this.fOldName = name;
        this.fNewName = name;
        this.fOldIndex = index;
        this.fIsDeleted = false;
    }

    public static ParameterInfo createInfoForAddedParameter(String type, String name) {
        ParameterInfo info = new ParameterInfo("", "", -1);
        info.setNewTypeName(type);
        info.setNewName(name);
        return info;
    }

    public static ParameterInfo createInfoForAddedParameter(String type, String name, String defaultValue) {
        ParameterInfo info = new ParameterInfo("", "", -1);
        info.setNewTypeName(type);
        info.setNewName(name);
        info.setDefaultValue(defaultValue);
        return info;
    }

    public int getOldIndex() {
        return this.fOldIndex;
    }

    public boolean isDeleted() {
        return this.fIsDeleted;
    }

    public void markAsDeleted() {
        Assert.isTrue((!this.isAdded() ? 1 : 0) != 0);
        this.fIsDeleted = true;
    }

    public boolean isAdded() {
        return this.fOldIndex == -1;
    }

    public boolean isTypeNameChanged() {
        return !this.fOldTypeName.equals(this.fNewTypeName);
    }

    public boolean isRenamed() {
        return !this.fOldName.equals(this.fNewName);
    }

    public String getOldTypeName() {
        return this.fOldTypeName;
    }

    public String getNewTypeName() {
        return this.fNewTypeName;
    }

    public void setNewTypeName(String type) {
        Assert.isNotNull((Object)type);
        this.fNewTypeName = type;
    }

    public String getOldName() {
        return this.fOldName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void setNewName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewName = newName;
    }

    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setDefaultValue(String value) {
        Assert.isNotNull((Object)value);
        this.fDefaultValue = value;
    }

    public String toString() {
        return String.valueOf(this.fOldTypeName) + " " + this.fOldName + " @" + this.fOldIndex + " -> " + this.fNewTypeName + " " + this.fNewName + ": " + this.fDefaultValue + (this.fIsDeleted ? " (deleted)" : " (stays)");
    }
}

